#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/*
 *   TADS simuluje i tzv. postoje hráče, aby se např. rozlišilo, zda na židli
 *   sedí nebo stojí. Může se to hodit v určitých zápletkách a hlavolamech.
 *   V základní výbavě je stání, sezení a ležení, nic ovšem nebrání přidat své
 *   vlastní postoje. Ve vesmíru se používají spacáky přidělané ke stěně a
 *   postava v nich visí.
 *
 *   Hlavně je potřeba správně zadat vlastnosti, které se pak vkládají do hlášek
 *   o aktuální poloze hráče (participle) nebo změny postoje (msgVerb*).
 *   Přídomky "Present" a "Past" jsou jasné, ty rozlišují sloveso v přítomném a
 *   minulém čase. Sloveso v obou časech se ale ještě rozlišuje na transitivní a
 *   intransitivní, čili přechodné a nepřechodné, což značí, zda za za slovesem
 *   stojí či nestojí objekt. I když zrovna tady to není důležité.
 */
hanging: Posture
    setActorToPosture(actor, loc)
    {
        actor.moveIntoForTravel(loc);
        actor.posture = hanging;
    }
    msgVerbIPresent = 'zalézá'
    msgVerbIPast = 'zalezl'
    msgVerbTPresent = 'leze'
    msgVerbTPast = 'lezl'
    participle = 'visíš'
;

/*
 *   Objekt, který reprezentuje postavu hráče ve hře. Obvykle se pojmenovává
 *   krátce "me", protože se na něj budeme občas odvolávat. Třídu Attachable tu
 *   máme kvůli hrátkám se stetoskopem.
 */
me: Attachable, Actor

    /*
     *   Nechceme postavě dát jméno (name), aby nás hra nazývala jen zájmenem.
     *   Slovník ale raději dáme.
     */
    vocabWords = 'tobiáš'
    gender = 1

    /*
     *   Nechceme se trápit tím, že by postava něco neunesla a protože jsme
     *   ladili velikosti předmětů kvůli tomu, aby nešly nacpat velké věci do
     *   ohřívače atp., tak by se to při výchozí nosnosti stát mohlo.
     */
    maxSingleBulk = 10000

    desc = "Jsi čerstvý absolvent orbitální akademie V. M. Komarova, máš za
        sebou něco málo přes rok létání na krátkých trasách v okolí Měsíce a
        Země. Tohle je tvá první delší cesta. "

    /* Hra začíná hráčovým probuzením, takže hráč visí ve spacáku. */
    location = ycSleepingBag
    posture = hanging

    /* Mají být hinty v debug režimu přístupné všechny hned? */
    showAllHints = true

    /*
     *   Záchytný bod, kde můžeme reagovat na jakoukoliv akci, která se odehrává
     *   v naší přítomnosti. My zde chceme odchytit pár speciálních stavů, které
     *   nejsou specifické jedné konkrétní akci či objektu.
     */
    beforeAction()
    {
        /*
         *   Když je hráč myšlenkově spojen se strojem na konci hry, tak je v
         *   jakémsi transu, kdy jde vše kolem něj pryč. Když se pokusí udělat
         *   něco jiného, než několik specifických akcí (či systémových příkazů
         *   jako uložení hry), tak z toho transu vypadne. Ale na příkaz, o
         *   který se pokoušel, nedojde, zrušíme ho (kdyby ho hned provedl,
         *   působilo by to divně).
         */
        if(machine.daemonId && gAction != nil && !gAction.ofKind(SystemAction)
            && !gActionIn(Look, Examine, EnterOn, ThinkAbout))
        {
            /* Zastavíme démona měnícího příklady. */
            if(machine.daemonId) machine.daemonId.removeEvent();
            machine.daemonId = nil;

            /* Otevřeme schánky. */
            scanner.makeOpen(true);
            printer.makeOpen(true);

            /*
             *   Prováděnou akci chceme zrušit a proto potřebujeme také smazat
             *   cokoliv, co se mohlo už na obrazovku chtít napsat (jako např.
             *   nějaká imlicitní akce). Všechny výstupy na obrazovku nejdou
             *   přímo, ale zachytávají se v tzv. transkriptu. Vypneme ho, tím
             *   můžeme rovnou napsat náš text a vše doposud zachycené zahodíme.
             *   Transkript pak znovu aktivjeme a zrušíme všechny další příkazy.
             */
            gTranscript.deactivate();
            "Zalekl ses představy vnuknuté strojem a ucukl jsi
                rukou z prohlubně. Vědomí se ti prudce vyjasnilo, nebýt tu
                gravitace zcela nepatrná, asi bys sebou seknul. ";
            gTranscript.clearReports();
            gTranscript.activate();

            /* A teď akci stornujeme, zahodíme celou příkazovou řádku. */
            throw new CancelCommandLineException;
        }

        /*
         *   Skafandr nás různě omezuje a tak musíme pořešit některé akce, které
         *   by ve skafandru nedávaly smysl.
         */
        if((spaceSuit.isWornBy(me) || roverSuit.isWornBy(me)) &&
            gActionIn(Drink, Eat, Taste))
        {
            "Ve skafandru nemůžeš nic jíst ani pít. ";

            throw new CancelCommandLineException;
        }

        if((spaceSuit.isWornBy(me) || roverSuit.isWornBy(me)) &&
            gActionIn(ListenImplicit, ListenTo))
        {
            "Slyšíš jen vlastní dech a tiché bzučení systémů skafandru. Ani
                rádio se neozývá. ";

            throw new CancelCommandLineException;
        }

        if((spaceSuit.isWornBy(me) || roverSuit.isWornBy(me)) &&
            gActionIn(Smell, SmellImplicit))
        {
            "Ve skafandru cítíš jen sám sebe. ";

            throw new CancelCommandLineException;
        }

        /* A ještě pár omezení v rozvodech nad skladem. */
        if((me.isIn(supplyConducts) || me.isIn(technicianConducts)) &&
            gActionIn(Yell))
        {
            "Teď opravdu není dobrý nápad se chovat hlučně. ";

            throw new CancelCommandLineException;
        }

        if((me.isIn(supplyConducts) || me.isIn(technicianConducts)) &&
            gActionIn(Throw, ThrowAt, ThrowDir, ThrowTo))
        {
            "Teď opravdu není dobrý nápad ničím házet a chovat se hlučně. ";

            throw new CancelCommandLineException;
        }

        inherited;
    }

    /* Záchytný bod, který umožňuje odchytit, že postava hráče vstává. */
    standUp()
    {
        /*
         *   Po převzetí služby až do nehody mu neumožníme odejít. Kontrola
         *   musí být tady i jako dobjGetOutOf křesla.
         */
        if(gRevealed('me-driving') && !gRevealed('ship-malfunction'))
            reportFailure('Rád bys vstal, ale smysl pro povinnost ti nedovoluje
                zanedbávat službu jen tak z rozmaru. ');

        /* Jídlo mu zabere právě tak, aby mu kapitán stihl předat součástky. */
        else if(gRevealed('lunch') && me.isIn(bench) &&
                (strawberries.isIn(platter) || pasta.isIn(platter)))
            reportFailure('Seď, není slušné odcházet od stolu, když jsi
                nedojedl. ');

        else inherited;
    }

    /* Vtip se stetoskopem, když ho hráč přiloží sám k sobě. */
    handleAttach(other)
    {
        "Neslyšíš nic! Neztratil jsi posledně na Zemi srdce? Ne, jen neumíš
            používat stetoskop -- škrund, žblunk, škrrr. Ten tvůj žaludek je
            teda pěkně hlučný. ";

        /*
         *   We don't actually stay attached; attaching to us is just
         *   momentary probing.  So mark us as no longer attached.
         */
        detachFrom(other);
    }
;

/*
 *   AlwaysWorn je vlastní třída pro "oblečení", které hráč nemůže sundat.
 *
 *   Hodinky jsou spíše jen pro srandu, ale ukazují čas ve hře, který postupně
 *   realisticky plyne. Používáme na to rošířené subjective time a ve hře je
 *   definováno několik časových bodů v různých fázích hry. Hodinky mezi tím čas
 *   interpolují a předstírají, že skutečně plyne.
 */
+ AlwaysWorn 'digitální náramkové hodinky' 'hodinky' *3
    "Prastaré digitální hodinky z doby, kdy displeje bývaly monochromatické a
        zobrazovaly pouze čísla. <<extendedDesc()>>Momentálně ukazují
        <<clockManager.checkTimeFmt('24h.mm')>>. "

    isPlural = true

    /* Hodinky se opravdu nemají plést do příkazů jako prozkoumej vše. */
    hideFromAll(action) { return true; }

    extendedDesc()
    {
        /* Tahle poznámka se časem okouká, takže ji zobrazíme jen dvakrát. */
        if (extendedDescCount++ < 2)
            "Památka na dědu. Nedávno jsi je seřizoval podle koordinovaného
                centrálního času, ale maličko se předbíhají, zhruba o sekundu
                každý den. ";
    }
    extendedDescCount = 0

    dobjFor(Open)
    {
        verify() { illogical('Na jejich otevření bys musel mít nějaké hodinářské
            nástroje a i kdyby, tak je spíš rozbiješ, než vylepšíš. '); }
    }
    dobjFor(LookIn) asDobjFor(Open)

    cannotSetToMsg = "Nedávno jsi je nastavoval, zatím jdou celkem přesně. "
    cannotDoffMsg = "Raději ne, snadno by se ztratily, kdybys je neměl. "

    probeWithUnidip()
    {
        "Tyto hodinky nemají univerzální testovací rozhraní. ";
    }
    
    gcName = 'hodinek, hodinkám, hodinky, hodinkách, hodinkami'
    gcVocab = 'digitálních digitálním digitálními náramkových náramkovým
        náramkovými hodinek/hodinkám/hodinkách/hodinkami'
;

/*
 *   Tohle je jediná standardní akce bez objektů, kterou pro potřeby hry
 *   upravujeme. Ve dvou místnostech zareagujeme speciálním způsobem.
 */
modify JumpAction
    execAction()
    {
        if(gActor.isIn(tunnel))
        {
            "Vyskočil jsi do výšky, lehce jsi plácnul dlaněmi v rukavicích do
                stropu, odrazil ses a zas jsi plynule přistál. ";
        }
        else if(gActor.isIn(supplyRoom))
        {
            "Vyskočil jsi do výšky a přistál jsi na pracovním stole. ";
            me.moveIntoForTravel(srTable);
            srTable.hasBeenStoodOn = true;
        }
        else
            inherited;
    }
;
