#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/* Kvůli odpovědím na captcha akce "mysli na xxx". */
DefineLiteralAction(ThinkAbout)
    execAction()
    {
        if(!gActor.isIn(alienRoom) || !machine.daemonId)
        {
            "Zamyslel ses, ale nic kloudného tě nenapadlo. ";
            return;
        }
        machine.processInput(getLiteral());
    }
;

VerbRule(ThinkAbout)
    ('mysli' | 'myslet' | 'pomysli' | 'pomyslet' | 'přemýšlej' | 'přemýšlet'
    | 'představ' | 'představit')
    ('si' | ) ('o' | 'na' | ) ('číslo' | 'číslu' | 'čísle' | ) singleLiteral
    : ThinkAboutAction
    verbPhrase = 'myslet/mysl{íš}/myslel{a} (na co)'
    askDobjResponseProd = onSingleNoun
;

/*
 *   Preparser, který zajistí, že když hráč u šifry zadá bezmyšlenkovitě pouze
 *   číslo jako odpověď na otázku promítnutou do mysli replikátorem, tak ji
 *   zachytíme a pochopíme.
 */
numberOnlyPreParser: StringPreParser
    doParsing(str, which)
    {
        if(gActor.isIn(alienRoom) && machine.daemonId
            && str.match(R'^[0-9]+$')) return 'mysli ' + str;

        return str;
    }
;

/* V tajemné místnosti jsou stěny, podlaha a strop přeci jen neobyčejné. */
alienFloor: defaultFloor
    desc = "Prohlédl sis části místnosti tvořené tmavou hmotou. Vše se zdá být
        velice pevné, dokonale přesně vyrobené, nikde nejsou patrné stopy po
        nástrojích ani spáry. A samozřejmě, hmota je tmavá. "
;

alienCeiling: defaultCeiling
    desc = "Prohlédl sis části místnosti tvořené tmavou hmotou. Vše se zdá být
        velice pevné, dokonale přesně vyrobené, nikde nejsou patrné stopy po
        nástrojích ani spáry. A samozřejmě, hmota je tmavá. "
;

alienNorthWall: defaultNorthWall
    desc = "Prohlédl sis části místnosti tvořené tmavou hmotou. Vše se zdá být
        velice pevné, dokonale přesně vyrobené, nikde nejsou patrné stopy po
        nástrojích ani spáry. A samozřejmě, hmota je tmavá. "
;

alienSouthWall: defaultSouthWall
    desc = "Prohlédl sis části místnosti tvořené tmavou hmotou. Vše se zdá být
        velice pevné, dokonale přesně vyrobené, nikde nejsou patrné stopy po
        nástrojích ani spáry. A samozřejmě, hmota je tmavá. "
;

alienEastWall: defaultEastWall
    desc = "Prohlédl sis části místnosti tvořené tmavou hmotou. Vše se zdá být
        velice pevné, dokonale přesně vyrobené, nikde nejsou patrné stopy po
        nástrojích ani spáry. A samozřejmě, hmota je tmavá. "
;

alienWestWall: defaultWestWall
    desc = "Prohlédl sis části místnosti tvořené tmavou hmotou. Vše se zdá být
        velice pevné, dokonale přesně vyrobené, nikde nejsou patrné stopy po
        nástrojích ani spáry. A samozřejmě, hmota je tmavá. "
;

/* ------------------------------------------------------------------------ */
/*
 *   MIMOZEMSKÁ LOĎ
 */
alienRoom: Room 'Objevená místnost' 'do objevené místnosti'
    "<<if machine.daemonId != nil>>Své okolí téměř nevnímáš, jen s velkým úsilím
        si uvědomuješ, že se nacházíš ve skafandru s rukou položenou na
        prohlubni stroje. Všechny tvé myšlenky směřují k úloze zadané strojem.
        <<else>>Jsi v nezvyklé místnosti s hladkou tmavou podlahou a klenutým
        stropem, po obvodu stěn stojí masivní zaoblené sloupy podpírající strop
        jako žebra. Překvapivě tu není úplná tma, sloupy od okamžiku tvého
        příchodu po stranách žhnou slabým oranžovým světlem a nepřímo osvětlují
        celou místnost. "

    west = alienPassage
    
    /* Vyměníme standardní součásti místnosti za naše upravené. */
    roomParts = [alienFloor, alienCeiling, alienNorthWall, alienSouthWall,
        alienEastWall, alienWestWall]

    pressure = 0
    
    gender = 3
    gcName = 'objevené místnosti, objevené místnosti, objevenou místnost,
        objevené místnosti, objevenou místností'
    vocabWords = 'objevená objevené objevenou místnost/místnosti/místností'
;

+ alienPassage: ThroughPassage
    'vstupní chodba' 'vstupní chodba' *3
    "Stěny vstupní chodby jsou pokryté tmavou hmotou stejně jako stěny místnosti
        na kterou plynule navazuje. Geometrická dokonalost tvarů tě nepřestává
        překvapovat. "

    /* Pokud hráč v místnosti na něco mířil, po průchodu ven přestane. */
    dobjFor(TravelVia)
    {
        action()
        {
            inherited;
            laser.target = nil;
        }
    }

    gcName = 'vstupní chodby, vstupní chodbě, vstupní chodbu, vstupní chodbě,
        vstupní chodbou'
    gcVocab = 'chodby/chodbě/chodbu/chodbou'
;

/* Vaporous je objekt představující něco nehmatného obklopujícího. */
+ Vaporous 'slabé oranžové světlo' 'světlo' *4
    "Není moc silné a je spíš do červena, ale pro orientaci stačí. Jestli tohle
        nepostavili lidé, odkud stavitelé pocházeli? Jaká asi hvězda svítila na
        jejich svět? "

    gcName = 'světla, světlu, světlo, světlu, světlem'
    gcVocab = 'slabého slabému slabém slabým oranžového oranžovému oranžovém
        oranžovým světla/světlu/světlem'
;

+ Component 'tmavá hmota' 'tmavá hmota' *3
    "Prohlédl sis části místnosti tvořené tmavou hmotou. Vše se zdá být velice
        pevné, dokonale přesně vyrobené, nikde nejsou patrné stopy po nástrojích
        ani spáry. A samozřejmě, hmota je tmavá. "
    
    gcName = 'tmavé hmoty, tmavé hmotě, tmavou hmotu, tmavé hmotě,
        tmavou hmotou'
    gcVocab = 'tmavé tmavou hmoty/hmotě/hmotu/hmotou'
;

/* ------------------------------------------------------------------------ */

+ machine: Heavy 'nezvyklý přístroj/stroj' 'nezvyklý přístroj' *2
    "Přístroj zvnějšku vypadá jako dva tmavohnědé válcové sloupy, nahoře
        zaoblené, mezi nimi je velká černá koule směrem ke vchodu zploštělá.
        Uprostřed plochy je tmavočerveně světélkující kruh s prohlubní ve tvaru
        čtyřprsté ruky. Ve sloupech jsou otevřené přihrádky.<<sheet.discover>> "

    /* Je to tak důležitý objekt, tak má svůj odstavec při rozhlédnutí. */
    initSpecialDesc = "<<if machine.daemonId == nil>>Uprostřed místnosti stojí
        nezvyklý přístroj. "

    dobjFor(EnterOn)
    {
        verify()
        {
            if(!gActor.isIn(alienRoom) || !machine.daemonId)
                illogicalNow('Nevidíš žádný způsob, jak bys do stroje mohl něco
                    zadat. ');
        }
        action() { replaceAction(ThinkAbout, gLiteral); }
    }

    dobjFor(TurnOn) remapTo(Push, alienButton)

    iobjFor(PutIn)
    {
        verify() {}
        action()
        {
            "Ten nezvyklý přístroj má dvě přihrádky. Budeš muset říci, do které
                chceš {kohoco dobj} dát. ";
        }
    }

    daemonId = nil

    number1 = 0
    number2 = 0
    guessLog = ['0', '0', '0', '0', '0']
    guessIdx = 1
    numGuesses = 0

    /*
     *   Démon každých 30 sekund vygeneruje nový příklad pro captchu. Vyhýbáme
     *   se důsledně příkladům, které by měly stejný výsledek při počítání v
     *   desítkové soustavě, čili použijeme jen takové příklady, u nichž dojde
     *   při výpočtu k přenosu do vyššího řádu. Také si pamatujeme pět
     *   posledních hodnot, které hráč hádal a vyhneme se jim pro případ, že by
     *   zkoušel pořád to samé a čekal, kdy se trefí.
     */
    cipherDaemon()
    {
        local recent;
        do
        {
            /* Generujeme dvě dvojmístná čísla v osmičkové soustavě. */
            number1 = rand(64);
            number2 = rand(64);

            /* Vyhnutí se posledním zadaným odpovědím hráče. */
            recent = nil;
            for(local i = 1; i <= 5; i++)
            {
                if(guessLog[i] == sprintf('%0' + guessLog[i].length + 'o',
                    number1 + number2)) recent = true;
            }

/* Při automatickém testu se vyhneme náhodě. */
#ifdef __DEBUG
            number1 = 4;
            number2 = 4;
#endif
        }
        while(number1 % 8 + number2 % 8 < 8 && number1 / 8 + number2 / 8 < 8
            || recent || sprintf('%03o', number1 + number2) == 100);

        if(daemonId != nil)
            "<<one of>>Tvé myšlenky pohlcuje neodbytná představa<<or>>Neodbytně
                se ti vnucuje<<or>>Neodbytně se ti vnucuje úloha<<or>>Nemůžeš
                myslet skoro na nic jiného než na<<or>>Hlavou ti víří<<or>>Tvé
                vnímání zcela přehlušuje představa<<half shuffled>> ";

        /* Číslo pochopitelně formátujeme do osmičkové soustavy. */
        "<<%o number1>> + <<%o number2>>. ";
    }

    startDaemon()
    {
        daemonId = new RealTimeDaemon(self, &cipherDaemon, 30000);
    }

    /* Zpracujeme co zadal hráč. */
    processInput(literal)
    {
        /*
         *   Nejprve stejně musíme zastavit démona, ať už vyřešil či
         *   nevyřešil. Pokud nevyřešil, tak chceme zadat hned další jiný
         *   příklad.
         */
        if(daemonId) daemonId.removeEvent();
        daemonId = nil;

        /* Pamatujeme si posledních pět odpovědí, co hráč hádal. */
        guessLog[guessIdx] = literal;
        guessIdx++;
        if(guessIdx == 6) guessIdx = 1;

        /*
         *   Správný výsledek necháme naformátovat na stejný počet cifer
         *   doplněním nul vlevo, aby bylo číslo stejně dlouhé, jako číslo
         *   hádané uživatelem. Potom porovnáme jako řetězce.
         */
        if(literal == sprintf('%0' + literal.length + 'o', number1
            + number2))
        {
            "Pomyslel sis <<literal>>. Vědomí se ti vyjasnilo a uvědomil
                sis, že stojíš přesně na stejném místě jako před chvílí,
                jako by neuběhl ani okamžik. ";

            gReveal('machine-solved');
            achievement.awardPointsOnce();

            /* A konečně spustíme replikaci. */
            runReplication();
        }
        else
        {
            /*
             *   Zde musí být find a ne match, který by zkoumal jen od
             *   začátku řetězce.
             */
            if(literal.find(R'[89]'))
            {
                /*
                 *   Hintujeme osmičkovou soustavu. Pokud odpověď obsahuje
                 *   osmičku či devítku, podivíme se tomu.
                 */
                "Pomyslel sis <<literal>>, myšlenkami ti proběhl záchvěv údivu
                    nad nesrozumitelnými symboly. Neodbytná představa se změnila
                    na ";
                
                gReveal('hint-symbols');
            }
            else
                "Pomyslel sis <<literal>>, ale nestalo se nic zvláštního,
                    jen s náznakem lehkého zklamání se změnila neodbytná
                    představa na ";

            /* Jednorázově vygenerujeme nový příklad a načasujeme jeho změnu. */
            cipherDaemon();
            daemonId = new RealTimeDaemon(self, &cipherDaemon, 30000);

            /* Po každých třiceti marných pokusech dloubneme do hráče. */
            numGuesses++;
            if(numGuesses % 30 == 0) "<.p><q>Safra,</q> pomyslel sis, <q>přeci
                tomu musím přijít na kloub. Určitě musím více přemýšlet, než jen
                bezmyšlenkovitě hádat!</q> ";
        }
    }

    /* Provedeme replikaci. */
    runReplication()
    {
        local printerBatt = 0;

        /*
         *   Nejprve spočítáme předměty ve výrobníku a zároveň je z přihrádky
         *   odstraníme.
         */
        if(charged1.isIn(printer))
        {
            printerBatt++;
            charged1.moveInto(nil);
        }
        if(charged2.isIn(printer))
        {
            printerBatt++;
            charged2.moveInto(nil);
        }
        if(charged3.isIn(printer))
        {
            printerBatt++;
            charged3.moveInto(nil);
        }
        if(discharged1.isIn(printer))
        {
            printerBatt++;
            discharged1.moveInto(nil);
        }
        if(discharged2.isIn(printer))
        {
            printerBatt++;
            discharged2.moveInto(nil);
        }
        if(discharged3.isIn(printer))
        {
            printerBatt++;
            discharged3.moveInto(nil);
        }
        if(pieces.isIn(printer))
        {
            printerBatt++;
            pieces.moveInto(nil);
        }

        "<.p>Podsvětlený kruh okolo prohlubně změnil barvu a začal pravidelně
            blikat, pohasla světla v celé místnosti. Chvíli se zdánlivě nic
            nedělo, pak přístroj otevřel obě přihrádky a světla se zas pomalu
            rozjasnila. ";

        /* Replikujeme-li nabitou baterku. */
        if(charged1.isIn(scanner) || charged2.isIn(scanner)
            || charged3.isIn(scanner))
        {
            /* Použijeme jednu z baterek, která je momentálně mimo hru. */
            if(charged1.location == nil)
            {
                charged1.eventualLocation = printer;
                charged1.makePresent();
            }
            else if(charged2.location == nil)
            {
                charged2.eventualLocation = printer;
                charged2.makePresent();
            }
            else if(charged3.location == nil)
            {
                charged3.eventualLocation = printer;
                charged3.makePresent();
            }

            /*
             *   Když jsme měli dvě baterky jako materiál, zbydou okousané
             *   zbytky, ze kterých jde udělat ještě jedna nabitá.
             */
            if(printerBatt > 1)
            {
                "<.p>V pravé přihrádce jsi objevil nabitý akumulátor do
                    nejmenších detailů shodný s akumulátorem v levé přihrádce a
                    zvláštním způsobem deformované kusy akumulátorů. ";

                pieces.makePresent();
            }
            else
            {
                "<.p>V pravé přihrádce jsi objevil nabitý akumulátor do
                    nejmenších detailů shodný s akumulátorem v levé přihrádce. ";
            }
        }

        /* Nebo replikujeme vybitou baterku? */
        else
        {
            if(discharged1.location == nil)
            {
                discharged1.eventualLocation = printer;
                discharged1.makePresent();
            }
            else if(discharged2.location == nil)
            {
                discharged2.eventualLocation = printer;
                discharged2.makePresent();
            }
            else if(discharged3.location == nil)
            {
                discharged3.eventualLocation = printer;
                discharged3.makePresent();
            }

            if(printerBatt > 1)
            {
                "<.p>V pravé přihrádce jsi objevil vybitý akumulátor do
                    nejmenších detailů shodný s akumulátorem v levé přihrádce a
                    zvláštním způsobem deformované kusy akumulátorů. ";

                pieces.makePresent();
            }
            else
            {
                "<.p>V pravé přihrádce jsi objevil vybitý akumulátor do
                    nejmenších detailů shodný s akumulátorem v levé
                    přihrádce. ";
            }
        }

        /* Zase otevřeme přihrádky. */
        scanner.makeOpen(true);
        printer.makeOpen(true);

        /* Jakmile jednou něco replikujeme, přiblíží se pronásledovatelé. */
        if(!gRevealed('replicated'))
        {
            gReveal('replicated');
            secondRover.discover();

            captain.moveIntoForTravel(secondRover);
            commander.moveIntoForTravel(secondRover);

            clock.eventReached();
        }
    }
    clock: ClockEvent { eventTime = [2, 15, 39] }
    achievement: Achievement { +5 "zprovoznění mimozemského přístroje" }
    
    gcName = 'nezvyklého přístroje, nezvyklému přístroji, nezvyklý přístroj,
        nezvyklém přístroji, nezvyklým přístrojem'
    gcVocab = 'nezvyklého nezvyklému nezvyklém nezvyklým přístroje/přístroji/
        přístrojem/stroje/stroji/strojem'
;

++ Component
    'levý tmavohnědý válcový povrch sloup/válec*sloupy' 'levý sloup' *2
    "Sloup se zdá být nedílnou součástí stroje přiléhající z boku k centrální
        kouli. Přibližně v horní čtvrtině je přihrádka, kousek nad přihrádkou
        sloup končí zaoblením. Povrch sloupu je tmavohnědý, matně hladký bez
        jakýchkoli výstupků. "

    gcName = 'levého sloupu, levému sloupu, levý sloup, levém sloupu,
        levým sloupem'
    gcVocab = 'levého levému levém levým tmavohnědého tmavohnědému tmavohnědém
        tmavohnědým válcového válcovému válcovém válcovým sloupu/sloupem/válce/
        válci/válcem'
;

+++ scanner: OpenableContainer, Component
    'levá přihrádka/kryt/(přístroje)/(stroje)*přihrádky' 'levá přihrádka' *3
    "Levá přihrádka zabírá kromě tloušťky své zadní stěny celou plochu sloupu,
        zadní stěna kryje asi polovinu obvodu. Na výšku by se do přihrádky mohla
        vejít láhev limonády a možná by ještě kousek místa zbylo. Povrch uvnitř
        je tmavý, matně hladký zcela bez výstupků nebo otvorů. "

    initiallyOpen = true
    bulkCapacity = 5

    dobjFor(Open)
    {
        check()
        {
            failCheck('Zkusil jsi otevřít přihrádku, ale zdá se, že tu není
                žádný způsob, jak hladký a zcela zasunutý kryt zachytit a
                přihrádku otevřít ručně. ');

            /*
             *   Pro případ, že hráč zadal příkaz v množném čísle, tak nechceme
             *   zbytečně to samé selhání opakovat s druhou přihrádkou.
             */
            gAction.cancelIteration();
        }
    }
    dobjFor(Close)
    {
        check()
        {
            failCheck('Zkusil jsi zavřít přihrádku, ale zdá se, že tu není žádný
                způsob, jak hladký a zcela zasunutý kryt zachytit a přihrádku
                zavřít ručně. ');

            gAction.cancelIteration();
        }
    }

    changeGender = 'kryt:2'
    gcName = 'levé přihrádky, levé přihrádce, levou přihrádku, levé přihrádce,
        levou přihrádkou'
    gcVocab = 'levé levou přihrádky/přihrádce/přihrádku/přihrádkou/krytu/krytem*
        přihrádek*přihrádkám*přihrádkách*přihrádkami'
;

++ Component
    'pravý tmavohnědý válcový povrch sloup/válec*sloupy' 'pravý sloup' *2
    "Sloup se zdá být nedílnou součástí stroje přiléhající z boku k centrální
        kouli. Přibližně v horní čtvrtině je přihrádka, kousek nad přihrádkou
        sloup končí zaoblením. Povrch sloupu je tmavohnědý, matně hladký bez
        jakýchkoli výstupků. "

    gcName = 'pravého sloupu, pravému sloupu, pravý sloup, pravém sloupu,
        pravým sloupem'
    gcVocab = 'pravého pravému pravém pravým tmavohnědého tmavohnědému
        tmavohnědém tmavohnědým válcového válcovému válcovém válcovým sloupu/
        sloupem/válce/válci/válcem'
;

+++ printer: OpenableContainer, Component
    'pravá přihrádka/kryt/(přístroje)/(stroje)*přihrádky' 'pravá přihrádka' *3
    "Pravá přihrádka zabírá kromě tloušťky své zadní stěny celou plochu sloupu,
        zadní stěna kryje asi polovinu obvodu. Na výšku by se do přihrádky mohla
        vejít láhev limonády a možná by ještě kousek místa zbylo. Povrch uvnitř
        je tmavý, matně hladký zcela bez výstupků nebo otvorů.
        <<checkDiscover()>> "

    initiallyOpen = true
    bulkCapacity = 5

    dobjFor(Open)
    {
        check()
        {
            failCheck('Zkusil jsi otevřít přihrádku, ale zdá se, že tu není
                žádný způsob, jak hladký a zcela zasunutý kryt zachytit a
                přihrádku otevřít ručně. ');

            gAction.cancelIteration();
        }
    }
    dobjFor(Close)
    {
        check()
        {
            failCheck('Zkusil jsi zavřít přihrádku, ale zdá se, že tu není žádný
                způsob, jak hladký a zcela zasunutý kryt zachytit a přihrádku
                zavřít ručně. ');

            gAction.cancelIteration();
        }
    }

    /* Vyrobíme kousky materiálu. */
    checkDiscover()
    {
        if(!mix.isIn(self))
        {
            mix.makePresent();
            new Fuse(self, &sayDiscover, 0);
        }
    }

    sayDiscover()
    {
        "<.p>V pravé přihrádce jsi objevil směs různých kousků materiálu. ";
        gReveal('mix-discovered');
    }

    changeGender = 'kryt:2'
    gcName = 'pravé přihrádky, pravé přihrádce, pravou přihrádku, pravé
        přihrádce, pravou přihrádkou'
    gcVocab = 'pravé pravou přihrádky/přihrádce/přihrádku/přihrádkou/krytu/
        krytem*přihrádek*přihrádkám*přihrádkách*přihrádkami'
;

++++ mix: PresentLater, CustomFixture
    'směs různé kousky materiál/materiály/tuha' 'směs materiálu' *3
    "Uvnitř je směs malých kousků plastu, pár různých kovových úlomků, snad
        kousky tuhy, dokonce i několik malých kamínků. Vše je zvláštním způsobem
        deformováno, snad otaveno, nebo odroleno. Jakoby něco prostě ohlodalo
        kousky materiálu. "

    cannotTakeMsg = 'Kousky materiálu jsou příliš drobné na to, abys s nimi mohl
        manipulovat v nemotorné rukavici skafandru.'
    cannotPutUnderMsg = 'Tu směs v téhle gravitaci ničím nenabereš a beztak
        nevypadá užitečně, spíše to jsou drobné zbytky různých materiálů. '

    /*
     *   Hráč často bude dávat příkaz "prozkoumej přihrádky" v množném čísle a
     *   jelikož dojde k objevení směsi prvním prozkoumáním, objevila by se
     *   uprostřed hromadné akce a vypadlo by to divně.
     */
    isListed = gRevealed('mix-discovered')
    isListedInContents = gRevealed('mix-discovered')

    /* Směs dohromady nic nezabírá. */
    bulk = 0
    
    changeGender = 'kousk:5, materiály:5, materiálů:5, materiálech:5'
    gcName = 'směsi materiálu, směsi materiálu, směs materiálu, směsi materiálu,
        směsí materiálu'
    gcVocab = 'směsi směsí různých různým různými kousků kouskům kouskách
        kouskami materiálu/materiálem/tuhy/tuze/tuhu/tuhou/materiálů/materiálům/
        materiálech'
;

/*
 *   Do zásoby si připravíme další akumulátory a kousky, které mohou potenciálně
 *   vzniknout činností. Nic dalšího už vzniknou nemůže, tak stačí připravit
 *   takhle staticky a jako skrytý objekt.
 */
++++ charged2: PresentLater, ChargedAccu;
++++ charged3: PresentLater, ChargedAccu;
++++ discharged3: PresentLater, DischargedAccu;

++++ pieces: PresentLater, Thing 'kusy zbytky akumulátorů' 'kusy akumulátorů' *2
    "Vypadá to jako dva nesymetrické kusy univerzálního akumulátoru, snad by
        dohromady objemem daly jeden celý akumulátor. Oba kusy jsou zvláštním
        způsobem ohlodané, snad otavené, ale řez je přitom zcela hladký, jakoby
        něco prostě odebralo hmotu bez použití nástroje. "

    bulk = 2

    dobjFor(Take)
    {
        action()
        {
            "Jakmile jsi kusy vzal do rukou, rozsypaly se ti po okolí na
                šrot. ";

            /* Odstraníme objekt ze hry. */
            self.moveInto(nil);
        }
    }

    /* Pomnožné číslo. */
    isPlural = true
    gcName = 'kusů akumulátorů, kusům akumulátorů, kusy akumulátorů,
        kusech akumulátorů, kusy akumulátorů'
    gcVocab = 'kusů kusům kusech zbytků zbytkům zbytcích -'
;

++ Component 'velká veliká černá koule' 'koule' *3
    "Centrální koule stroje výškou dosahuje asi do výše tvých ramen, povrch má
        matně černý bez výstupků nebo náznaku spár, kromě plochého místa v
        horní části s kruhovou prohlubní směřující k vstupní chodbě. "

    dobjFor(Push) remapTo(Push, alienButton)

    gcName = 'koule, kouli, kouli, kouli, koulí'
    gcVocab = 'velké velkou veliké velikou černé černou kouli/koulí'
;

+++ alienButton: Button, Component
    'světélkující ploché místo kruh/prohlubeň/prohloubení' 'prohlubeň' *3
    "Rozměry prohlubně nejsou příliš odlišné od lidské ruky v rukavici. Pokud je
        toto spínací tlačítko, tak obsluha přístroje musela mít dva protilehlé
        palce a dohromady jen čtyři prsty. "

    numPushes = 0
    dobjFor(Push)
    {
        /* Aby přístroj replikoval, musí v něm být správný vzor i materiál. */
        check()
        {
            gReveal('hint-push');
            
            /*
             *   Spočítáme počet baterek a dalších objektů v jednotlivých
             *   přihrádkách. V tuto chvíli nám je jedno, zda nabitých či
             *   vybitých, při kontrole jde jen o to, zda sedí "materiál".
             */
            local scannerBatt = 0, scannerOther = 0;
            local printerBatt = 0, printerOther = 0;

            if(charged1.isIn(scanner)) scannerBatt++;
            if(charged2.isIn(scanner)) scannerBatt++;
            if(charged3.isIn(scanner)) scannerBatt++;
            if(discharged1.isIn(scanner)) scannerBatt++;
            if(discharged2.isIn(scanner)) scannerBatt++;
            if(discharged3.isIn(scanner)) scannerBatt++;
            if(torch.isIn(scanner)) scannerOther++;

            if(charged1.isIn(printer)) printerBatt++;
            if(charged2.isIn(printer)) printerBatt++;
            if(charged3.isIn(printer)) printerBatt++;
            if(discharged1.isIn(printer)) printerBatt++;
            if(discharged2.isIn(printer)) printerBatt++;
            if(discharged3.isIn(printer)) printerBatt++;
            if(pieces.isIn(printer)) printerBatt++;
            if(torch.isIn(printer)) printerOther++;

            /* Ve výrobníku musí být alespoň tolik materiálu, co ve scanneru. */
            if(scannerBatt == 0 || scannerOther > 0
                || scannerBatt > printerBatt)
                failCheck('Opatrně jsi položil ruku do čtyřprsté prohlubně a
                    stiskl. Přístroj zavřel obě přihrádky a po chvilce jakoby
                    odmítavě zablikal kruhem okolo prohlubně a obě přihrádky zas
                    otevřel. ');
        }

        /* Dostali-li jsme se sem, přístroj něco zreplikuje. */
        action()
        {
            numPushes++;

            /* Zavřeme přihrádky. */
            scanner.makeOpen(nil);
            printer.makeOpen(nil);
            gReveal('machine-working');

            /* Druhá replikace jde už bez captchy. */
            if(gRevealed('machine-solved'))
            {
                "Opatrně jsi položil ruku do čtyřprsté prohlubně a stiskl. ";

                machine.runReplication();
            }

            /* Při první však musí hráč vyřešit šifru. */
            else
            {
                if(numPushes == 1)
                    "Opatrně jsi položil ruku do čtyřprsté prohlubně a stiskl.
                        Přístroj zavřel obě přihrádky.
                        <.p>Tvé vědomí se náhle na chvilku propadlo do temnoty.
                        <.p>Teď ti v myšlenkách víří chaoticky zběsilé představy
                        barev a jen postupně se uklidňují, až nakonec vnímáš
                        představu čísel. Aha, uvědomil sis, stroj se naladil na
                        tvé myšlení!
                        <.p>A teď zřejmě něco žádá, neodbytná představa vypadá
                        jako ";
                else
                    "Opatrně jsi položil ruku do čtyřprsté prohlubně a stiskl.
                        Přístroj zavřel obě přihrádky.
                        <.p>Tentokrát stroj reagoval rychle a v myšlenkách se ti
                        usídlida představa ";

                /* Zobrazíme příklad a načasujeme jeho změnu. */
                machine.cipherDaemon();
                machine.startDaemon();
            }
        }
    }

    /* Mimozemská tlačítka reagují i na pouhý dotek. */
    dobjFor(Feel) asDobjFor(Push)

    changeGender = 'kruh: 2'
    gcName = 'prohlubně, prohlubni, prohlubeň, prohlubni, prohlubní'
    gcVocab = 'světélkujícího světélkujícímu světélkujícím plochého plochému
        plochém plochým místa místu místem kruhu/kruhem/prohlubně/prohlubni/
        prohlubní/prohloubením'
;

+ sheet: Hidden 'list papíru/papír' 'list papíru' *2
    "Je to docela obyčejný list papíru, nejspíš vytržený a ztracený ze
        zápisníku. Je popsaný různě proškrtanými poznámkami.
        <.p><center>***</center>
        <.p>…zbyly na výstupu nepoužité, protože se v chemickém složení vzoru
        nevyskytovaly.
        <.p>25. březen
        <.p>Pokus 3
        <.p>Po prvních pokusech trvalo skoro den, než přístroj opět rozsvítil
        tlačítko.
        <.p>Dodal jsem asi 30 g tuhy. Vzorový diamant se tentokrát podařilo
        zkopírovat 5×, pak tuha došla a přístroj odmítl pracovat.
        <.p>Dostatek vhodného materiálu je opravdu nezbytný. Vypozorovat vliv
        krystalické struktury se nepodařilo, nesehnal jsem víc tuhy. Boris hlídá
        sklad, nechci budit podezření.
        <.p>31. Březen
        <.p>Porovnávání mikroskopické struktury jsme museli na delší čas
        přerušit kvůli závadě cívky mikroskopu, dosavadní výsledky slibné,
        rozdíly mezi kopií a originálem jsem nedokázal pozorovat.
        <.p>Spojil jsem se s H.S., snad stihne sehnat náhradní díly do toho
        našeho starého verku, musíme si být jistí dlouhodobou stabilitou kopie.
        <.p>2. Duben
        <.p>Prozkoumal jsem okolí UniScanem, ale zdroj energie, není…
        <.p><center>***</center>
        <.p>Tady zápis končí. Víc stránek tu bohužel nezůstalo. "

    /*
     *   Zobrazuje se v rámci popisu místnosti, dokud je objekt v tzv. úvodním
     *   stavu. To je normálně do doby, než s ním hráč pohne.
     */
    initSpecialDesc = "Ve stínu stroje se povaluje list papíru. "

    /* Papír může nacpat do přihrádek stroje, vejde se. */
    bulk = 1
    
    /* Tato metoda zajišťuje objevení Hidden objektu. Doprovodíme hláškou. */
    discover()
    {
        if(!moved)
            "<.p>Ve stínu stroje se povaluje list papíru. ";

        inherited;
    }

    /* Když stroj pohltí hráčovy myšlenky, vše ostatní jde stranou. */
    isListed = machine.daemonId == nil

    /* Jakmile hráč papír prozkoumá, tak ho sebere. */
    dobjFor(Examine)
    {
        preCond = static inherited + objHeld
    }
    dobjFor(LookIn) asDobjFor(Examine)
    dobjFor(Search) asDobjFor(Examine)

    gcName = 'listu papíru, listu papíru, list papíru, listu papíru,
        listem papíru'
    gcVocab = 'listu listem papíru/papírem'
;
