#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/* ------------------------------------------------------------------------ */
/*
 *   KUPOLE
 */
domeCeiling: RoomPart 'strop' 'strop' *2
    "Je kupolovitě zaoblený. "

    gcName = 'stropu, stropu, strop, stropu, stropem'
    gcVocab = 'stropu/stropem'
;

dome: BaseRoom 'Kupole' 'do kupole'
    "Kupole je jednou z mála „nadzemních“ částí základny. Většina základny je
        ukrytá pod povrchem, ten funguje částečně jako ochrana před
        mikrometeority a kosmickým zářením. Tvar kupole zvenku skutečně
        připomíná polokouli, ideální tvar pro udržení tlaku uvnitř. Po obvodu
        je vstup do přechodové komory na východě, držák na skafandry a na
        sever vstup do přechodového tunelu, na jehož druhém konci je teď
        zakotvena kosmická loď. "

    north = shipDoorOutside
    up asExit(north)
    east = airlockInnerDoorOutside
    out asExit(east)
    down = ladderDown

    /* Vyměníme běžný strop za ten speciální. */
    roomParts = static inherited
        - defaultCeiling + domeCeiling

    /* Tato metoda se spouští po každém tahu, kdy je hráč v místnosti. */
    roomDaemon()
    {
        /* Jakmile se vracíme do kupole po objevení podezřelého kontejneru. */
        if(suspiciousContainer.discovered
            && suspiciousContainer.location != nil)
        {
            "<.p>Sotva jsi prolezl do základny, tak jsi zaslechl ve vysílačce
                podivný rozhovor: <q>Počkej, ten kontejner tu nemůže zůstat, za
                chvíli půjde mladej ven s tím opraveným modulem.</q>

                <.p>Přikrčil ses u okénka ve dveřích tlakové komory a zahlédl
                dvě postavy stěhující podezřelý kontejner kamsi do vzdálenější
                části základny. ";

            suspiciousContainer.moveInto(nil);
            unSuspiciousContainer.makePresent();
            unFigures.makePresent();
            automata.moveInto(nil);
        }

        inherited;
    }

    gender = 3
    gcVocab = 'kupole/kupoli/kupolí/kopuli/kopulí'
    gcName = 'kupole, kupoli, kupoli, kupoli, kupolí'
;

/*
 *   Tyhle dveře jsou až na konci tunelu, nechceme, aby se na ně hráč z kupole
 *   odvolával, takže je nepopisujeme a nedáváme slovník.
 */
+ shipDoorOutside: SwitchableTravelWithMessage, IndirectLockable, Door -> shipDoor
    travelDesc = "Odrazil ses, vyšplhal do tunelu a s občasným odrazem
        vyskákal až do kosmické lodě. "

    /* Nemají být zahrnuty do žádného příkazu, když hráč řekne "vše". */
    hideFromAll(action) { return true; }

    /*
     *   Tato metoda má za úkol říci, jaké PreCondition je potřeba splnit před
     *   průchodem konektorem. Využijeme toho k přidání dvou vlastních, které
     *   zařídí, aby před odchodem hráč odložil skafandr, nechceme aby ho tahal
     *   po základně s sebou, a také si musí opět obout boty.
     */
    connectorTravelPreCond()
    {
        return inherited
            + new ObjectPreCondition(spaceSuit, objNotHeld)
            + new ObjectPreCondition(shoes, objWorn);
    }
;

/*
 *   EntryPortal je něco, čím se prochází do cíle cesty. Reaguje např. na příkaz
 *   "projdi tunelem" a další příkazy.
 */
+ EntryPortal -> shipDoorOutside 'přechodový tunel' 'přechodový tunel' *2
    "Přechodový tunel je utěsněný, atmosférou nafouknutý tunel umožňující
        astronautům relativně bezpečný přechod z jednoho kosmického zařízení do
        jiného, aniž by museli používat skafandry. Teď zrovna je jedním koncem
        připevněný ke kabině lodi a druhým koncem ke kupoli základny. "

    gcName = 'přechodového tunelu, přechodovému tunelu, přechodový tunel,
        přechodovém tunelu, přechodovým tunelem'
    gcVocab = 'přechodového přechodovému přechodovém přechodovým tunelu/
        tunelem'
;

/*
 *   Entrable je něco, do čeho lze vstoupit. Reaguje např. na příkaz "vstup do
 *   lodi" a další příkazy.
 */
+ Enterable -> shipDoorOutside
    'vesmírná vesmírné kosmická kosmické loď/konzerva/plavidlo' 'vesmírná loď' *3
    "Loď je ukotvená k rampě a k její kabině vede přechodový tunel. Víc toho
        odsud vidět není.<<me.setHim(shipDoorOutside)>> "

    /* Chceme reagovat i na "nastup do lodi". */
    dobjFor(Board) asDobjFor(Enter)

    hideFromAll(action) { return true; }
    
    gcName = 'vesmírné lodi, vesmírné lodi, vesmírnou loď, vesmírné lodi,
        vesmírnou lodí'
    gcVocab = 'vesmírné vesmírnou vesmírného vesmírnému vesmírném vesmírným
        lodi/lodí/konzervy/konzervě/konzervu/konzervou/plavidla/plavidlu/
        plavidlem'
;

/* ------------------------------------------------------------------------ */
/*
 *   StairwayDown je objek, po kterém se dá sejít nebo sešplhat.
 */
+ ladderDown: StairwayDown -> ladderUp 'žebřík' 'žebřík' *2
    "Lehký kovový žebřík zavěšený v průlezu v podlaze kupole, vede dolů do dolní
        chodby. "

    connectorTravelPreCond()
    {
        return inherited
            + new ObjectPreCondition(spaceSuit, objNotHeld)
            + new ObjectPreCondition(shoes, objWorn);
    }

    gcName = 'žebříku, žebříku, žebřík, žebříku, žebříkem'
    gcVocab = 'žebříku/žebříkem'
;

/* ------------------------------------------------------------------------ */
/*
 *   IndirectLockable je objekt, který může být zamknutý nebo odemknutý, ale
 *   změnu nemůže provést hráč ve hře přímo, ovládá se programem, v tomto
 *   případě v reakci na mačkání pák.
 */
+ airlockInnerDoorOutside: IndirectLockable, Door -> airlockInnerDoor
    'dveře (přechodové) (komory)/dveře' 'dveře přechodové komory' *3
    "Vypadají jako běžné tlakové dveře, natřené čistě bílou, s kovovými
        výztuhami a maličkým okénkem. Ovládají se pákou uvnitř přechodové
        komory. "

    isPlural = true
    gcName = 'dveří přechodové komory, dveřím přechodové komory, dveře
        přechodové komory, dveřích přechodové komory, dveřmi přechodové komory'
    gcVocab = 'dveří dveřím dveřích dveřmi'
;

+ Enterable -> airlockInnerDoorOutside
    'přechodová komora' 'přechodová komora' *3
    "Tlakové dveře na východě vedou do přechodové komory, kterou se dá vystoupit
        před základnu k přistávací rampě.
        <<me.setThem(airlockInnerDoorOutside)>> "

    hideFromAll(action) { return true; }
    
    gcName = 'přechodové komory, přechodové komoře, přechodovou komoru,
        přechodové komoře, přechodovou komorou'
    gcVocab = 'přechodové přechodovou komory/komoře/komoru/komorou'
;

/* ------------------------------------------------------------------------ */

+ hanger: RestrictedSurface, Fixture
    'držák (na) (skafandru)/(skafandry)/držák' 'držák' *2
    "Slouží k odložení skafandru. "

    /* Restricted kontejnery povolí umístění jen určitých objektů. */
    validContents = [spaceSuit]

    /*
     *   Výchozí hodnota je jen 10 a my jsme ve hře měnili velikosti objektů,
     *   aby se nedal např. dát do ohřívače atp. Skafandr má velikost 100.
     */
    maxSingleBulk = 10000

    iobjFor(PutIn) asIobjFor(PutOn)

    gcName = 'držáku, držáku, držák, držáku, držákem'
    gcVocab = 'držáku držákem držáku/držákem'
;

++ spaceSuit: Wearable
    'vesmírný skafandr/oblek' 'vesmírný skafandr' *2
    "Je to úplně obyčejný skafandr pro krátkodobý pobyt v otevřeném vesmíru. Je
        vybaven podporou života na několik hodin, pouzdrem na nářadí, svítilnou
        a vysílačkou s krátkým dosahem. "

    /* V naší hře se snažíme trochu rozlišit velikosti objektů. */
    bulk = 100

    dobjFor(Doff)
    {
        check()
        {
            /* Zabráníme svlečení skafandru ve vakuu. */
            if(gActor.getOutermostRoom.pressure == 0)
                failCheck('To by mělo fatální důsledky, kolem není vůbec žádný
                    vzduch. ');
        }
    }

    /*
     *   Aby hra byla trochu realističtější, tak před obléknutím skafandru
     *   sundáme boty a stetoskop.
     */
    dobjFor(Wear)
    {
        preCond = inherited
            + new ObjectPreCondition(shoes, objNotHeld)
            + new ObjectPreCondition(stethoscope, objNotWorn)
    }
    dobjFor(Enter) asDobjFor(Wear)

    dobjFor(Drop)
    {
        action()
        {
            /* Skafandr nenecháme povalovat po zemi. */
            if(gActor.isIn(dome)) replaceAction(PutOn, self, hanger);
            else inherited;
        }
    }

    iobjFor(AimAt)
    {
        action()
        {
            "Na obrazovce tabletu se zobrazilo označení skafandru a základní
                informace o tomto kusu. V kyslíkové láhvi zbývá kyslík na
                několik hodin. ";
        }
    }

    gcName = 'vesmírného skafandru, vesmírnému skafandru, vesmírný skafandr,
        vesmírném skafandru, vesmírným skafandrem'
    gcVocab = 'vesmírného vesmírnému vesmírném vesmírným skafandru/skafandrem/
        obleku/oblekem'
;

+++ RestrictedContainer, CustomFixture, Component
    'pouzdro (na) (nářadí)/pouzdro' 'pouzdro na nářadí' *4
    "Pouzdro na nářadí ti dovoluje bezpečně přenášet malé předměty, když máš
        skafandr oblečený na sobě. "

    cannotTakeMsg = 'Pouzdro není oddělitelné od skafandru. '

    gcName = 'pouzdra na nářadí, pouzdrem na nářadí, pouzdro na nářadí,
        pouzdru na nářadí, pouzdrem na nářadí'
    gcVocab = 'pouzdra pouzdrem pouzdru pouzdra/pouzdrem/pouzdru'
;

/*
 *   Pouzdro máme jen pro doplnění scenérie, žádné nářadí tam není. Unthing
 *   reprezentuje právě něco, co by hráč mohl chtít, ale z nějakého důvodu to
 *   zde není. Úkolem je vysvětlit, proč to tu není.
 */
++++ Unthing 'nářadí' 'nářadí' *4
    'Žádné nářadí tu teď není. '

    isPlural = true
    gcName = 'nářadí, nářadí, nářadí, nářadí, nářadím'
    gcVocab = 'nářadím'
;

+++ Component 'přilba/helma' 'přilba' *3
    "Důležitá součást skafandru, chrání tvou hlavu, poskytuje ti výhled okolo a
        spoustu dalších samozřejmostí. "

    gcName = 'přilby, přilbě, přilbu, přilbě, přilbou'
    gcVocab = 'přilby/přilbě/přilbu/přilbou/helmy/helmě/helmu/helmou'
;

++++ Flashlight, Component 'svítilna' 'svítilna' *3
    "Svítilna je nedílnou součástí přilby. Můžeš ji zapnout, nebo vypnout. "

    /*
     *   Svítilna dostane jas o hodnotě 1, což znamená, že i když je kolem tma,
     *   je stále v dosahu a hráč ji může rozsvítit.
     */
    brightnessOff = 1

    gcName = 'svítilny, svítilně, svítilnu, svítilně, svítilnou'
    gcVocab = 'svítilny/svítilně/svítilnu/svítilnou'
;

+++ Component 'vysílačka/rádio' 'vysílačka' *3
    "Vysílačka je zabudovaná v přilbě, stejně jako v každém skafandru. "

    gcName = 'vysílačky, vysílačce, vysílačku, vysílačce, vysílačkou'
    gcVocab = 'vysílačky/vysílačce/vysílačku/vysílačkou/rádia/rádiu/rádiem'
;

+++ Component 'podpora života' 'podpora života' *3
    "Podpora života je nezbytná součást každého skafandru regulující teplotu,
        vlhkost, umožňující dýchání… "

    gcName = 'podpory života, podpoře života, podporu života, podpoře života,
        podporou života'
    gcVocab = 'podpory podpoře podporu podporou -'
;

/* ------------------------------------------------------------------------ */
/*
 *   O postavách jsme se zmínili při vejití do základny, ale mezitím odešly.
 */
+ unFigures: PresentLater, Unthing 'dvě postava/postavy' 'postavy' *3
    'Postavy jsi zahlédl sotva na okamžik a už jsou pryč. Navíc všechny
        skafandry vypadají stejně. '

    isPlural = true
    changeGender = 'postavu:3'
    gcName = 'postav, postavám, postavy, postavách, postavami'
    gcVocab = 'postav/postavám/postavy/postavách/postavami/postavě/postavu/
        postavou'
;
