#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/* Jen aby tam došla NPC postava, hráč se tam nedostane. */
captainsCabin: ShipboardRoom 'room' 'room'
    port = captainsDoor
;

+ captainsDoor: Door
;

/* ------------------------------------------------------------------------ */
/*
 *   SPOLEČENSKÁ MÍSTNOST
 */
lrFloor: Floor 'tlumicí podlaha/polyuretan' 'podlaha' *3
    desc()
    {
        "Podlaha je složená ze čtvercových panelů pokrytých měkkým pružný
            polyuretanem. Dobře tlumí zvuky, které by se jinak nesly celou
            lodí. <<descPanel>> ";

    }
 
    /*
     *   Mozna by mohlo byt jako specialDesc primo u panelu/diry a pak by to
     *   bylo sem do podlahy vypsano automaticky.
     */
    descPanel()
    {
        if(gRevealed('ship-malfunction'))
        {
            if(lrPanel.isOpen)
                "Uprostřed podlahy zeje čtvercový otvor do podpalubí po
                    odsunutém panelu. ";
            else
                "Panel uprostřed místnosti má po okrajích madla a v rozích je
                    zajištěn otočnými zámky. ";
    
            if(!lrPanel.location)
                lrPanel.makePresent();
        }
    }
    
    /* Search je presmerovane na LookIn. Zajistime objeveni, jako u Examine. */
    dobjFor(LookIn)
    {
        action()
        {
            descPanel();
            inherited;
        }
    }
    dobjFor(Enter) maybeRemapTo(!lrPanelLock.isLocked, Enter, lrHole)

    objIntoCase = 4

    /*
     *   Kabina je spojena se společenskou místností smyslovým konektorem.
     *   Většinu objektů máme označenu, aby na dálku nebyla vidět.
     */
    sightSize = small

    changeGender = 'polyuretan:2, panel:2'
    gcName = 'podlahy, podlaze, podlahu, podlaze, podlahou'
    gcVocab = 'podlahy/podlaze/podlahu/podlahou/panelu/panelem/polyuretanu/
        polyuretanem/země/zemi/zemí'
;

lrForeWall: DefaultWall
    'přední zeď/přepážka/stěna*zdi*přepážky*stěny' 'přední stěna' *3
    "Přepážka přepažuje celý trup lodi. Je konstruována jako tlakuvzdorná a v
        nouzi je schopná udržet atmosféru, pokud se zavřou tlakové dveře. "

    sightSize = small

    gcName = 'přední stěny, přední stěně, přední stěnu, přední stěně,
        přední stěnou'
    gcVocab = 'zdi/zdí/přepážky/přepážce/přepážku/přepážkou/stěny/stěně/stěnu/
        stěnou*zdí*zdím*přepážek*přepážkám*přepážkách*přepážkami*stěn*stěnám*
        stěnách*stěnami'
;

lrAftWall: DefaultWall
    'zadní zeď/přepážka/stěna*zdi*přepážky*stěny' 'zadní stěna' *3
    "Část stěny pokryté odolným světlým plastem zabírá kuchyňka. "

    sightSize = small

    gcName = 'zadní stěny, zadní stěně, zadní stěnu, zadní stěně, zadní stěnou'
    gcVocab = 'zdi/zdí/přepážky/přepážce/přepážku/přepážkou/stěny/stěně/stěnu/
        stěnou*zdí*zdím*přepážek*přepážkám*přepážkách*přepážkami*stěn*stěnám*
        stěnách*stěnami'
;

livingRoom: DisambigDeferrer, ShipboardRoom
    'Společenská místnost' 'do společenské místnosti' 'ze společenské místnosti'
    "Společenská místnost je největší místností uprostřed lodi. Po stranách na
        levoboku a pravoboku jsou zvukotěsné a neprůhledné kryty spacích kójí.
        Vzadu pokrývá stěny malá vestavěná kuchyňka, nebo
        spíš sada automatů pro přípravu konzervovaného jídla a nápojů i ve stavu
        beztíže. Podlaha je pokrytá tlumicím polyuretanem, strop má v sobě
        vestavěné osvětlovací pásy a mřížky vzduchotechniky. V předním koutě
        stojí běžecký pás. Vstup do pilotní kabiny na přídi lze vzduchotěsně
        uzavřít. "

    /*
     *   Společenská místnost je vidět na dálku z kokpitu. DisambigDeferrer
     *   umožňuje ji potlačit ve prospěch uvedeného objektu.
     */
    disambigDeferTo = [ cLivingRoom ]

    gender = 3
    vocabWords = 'společenská společenské společenskou místnost/místnosti/
        místností'
    gcName = 'společenské místnosti, společenské místnosti, společenskou
        místnost, společenské místnosti, společensko místností'

    fore = cDoorOutside
    port = ycDoorOutside
    down = lrHole
    starboard = captainsDoorOutside
    roomParts = static inherited
        - shipFloor + lrFloor
        - foreWall + lrForeWall
        - aftWall + lrAftWall
;

/* ------------------------------------------------------------------------ */

+ Enterable -> captainsDoorOutside
    'kapitánova spací kóje/kój/(kapitána)*kóje' 'kapitánova kóje' *3
    "Kapitánova kóje je na pravoboku. "

    sightSize = small
    hideFromAll(action) { return true; }
    
    gcName = 'kapitánovy kóje, kapitánově kóji, kapitánovu kóji,
        kapitánově kóji, kaptánovou kójí'
    gcVocab = 'kapitánovy kapitánově kapitánovu kaptánovou spací kóji/kójí'
;

+ captainsDoorOutside: AutoClosingDoor -> captainsDoor
    'kryt (kóje)*kryty kójí' 'kryt kapitánovy kóje' *2
    "Kryt zakrývá vstup do kapitánova malého soukromého prostoru. Kosmonauti nemají
        mnoho soukromí, a proto si ho pečlivě střeží. Kryt je odklápěcí, vyrobený
        ze světlého plastu, zevnitř pokrytý hmotou dobře tlumící zvuk. Zavřený
        kryt takřka splývá se stěnou. "

    sightSize = small

    dobjFor(Open)
    {
        check()
        {
            if(gActor == me && gRevealed('ship-malfunction') && !gRevealed('ship-landed'))
                failCheck('Opatrně jsi otevřel kapitánovu kóji a nakoukl dovnitř. V přítmí
                    jsi rozeznal kapitánův spací vak, pokoušíš se rozenat
                    samotného kapitána: <q>Kapitáne, opatrně jsi zašeptal,</q>
                    ale v odpověď se ti ozvalo jen bohatýrské zachrápání.
                    <q>Kapitáne,</q> přidal jsi na hlase, <q>máme problém!</q>
                    Opatrně jsi natáhl ruku a uchopil kapitána za rameno.
                    <q>KAPITÁNE</q>, zalomcoval jsi jím. Chrápaní přešlo v
                    mohutné zachrochtání, zachrčení, následované několika
                    mohutnými nádechy. Toho nevzbudíš. Tak jsi to vzdal a vrátil
                    se.<.reveal hint-wake-up> ');
            else if(gActor == me)
                failCheck('Do kapitánovy kóje nemůžeš. Kapitán si svůj soukromý prostor
                    přísně střeží. ');
        }
        action()
        {
            /* Potlačíme "Kapitán otevírá kryt kapitánovy kóje." */
            "<.p0>";
            inherited;
        }
    }

    gcName = 'krytu kapitánovy kóje, krytu kapitánovy kóje, kryt kapitánovy
        kóje, krytu kapitánovy kóje, krytem kapitánovy kóje'
    gcVocab = 'krytu krytem -*krytů krytům kryty krytech'
;

/* ------------------------------------------------------------------------ */

+ ycEnterable: Enterable -> ycDoorOutside 'spací kóje/kój*kóje' 'tvoje kóje' *3
    "Tvoje kóje je na levoboku. "

    owner = me
    sightSize = small
    hideFromAll(action) { return true; }
    
    gcName = 'tvé kóje, tvé kóji, tvoji kóji, tvé kóji, tvou kójí'
    gcVocab = 'kóji/kójí'
;

+ ycDoorOutside: Door -> ycDoor 'kryt (kóje)*kryty kójí' 'kryt tvojí kóje' *2
    "Kryt zakrývá vstup do tvého malého soukromého prostoru. Kosmonauti nemají
        mnoho soukromí, a proto si ho pečlivě střeží. Kryt je odklápěcí, vyrobený
        ze světlého plastu, zevnitř pokrytý hmotou dobře tlumící zvuk. Zavřený
        kryt takřka splývá se stěnou. "

    sightSize = small

    gcName = 'krytu tvojí kóje, krytu tvojí kóje, kryt tvojí kóje, krytu tvojí
        kóje, krytem tvojí kóje'
    gcVocab = 'krytu krytem -*krytů krytům kryty krytech'
;

/* ------------------------------------------------------------------------ */

+ lrCockpit: Enterable -> cDoorOutside
    'pilotní kabina' 'pilotní kabina' *3
    "Pilotní kabina je na přídi. "

    dobjFor(Open) remapTo(Open, cDoorOutside)
    dobjFor(Close) remapTo(Close, cDoorOutside)
    hideFromAll(action) { return true; }
    
    gcName = 'pilotní kabiny, pilotní kabině, pilotní kabinu, pilotní kabině,
        pilotní kabinou'
    gcVocab = 'kabiny/kabině/kabinu/kabinou'
;

+ cDoorOutside: Door -> cDoor
    'tlakové vstup (do) (pilotní) (kabiny) dveře/těsnění' 'tlakové dveře' *3
    "Jsou to mohutné dveře schopné udržet atmosféru v oddělené části lodi. Po
        obvodu je měkké těsnění, které občas prověřuješ. Z obou stran jsou
        výrazné tlakoměry ukazující tlak na druhé straně dveří. V případě
        potřeby tlakový uzávěr může lehce zaklapnout a udrží i velmi prudkou
        změnu tlaku. "

    isPlural = true
    sightSize = small

    changeGender = 'těsn:4'
    gcName = 'tlakových dveří, tlakovým dveřím, tlakové dveře, tlakových
        dveřích, tlakovými dveřmi'
    gcVocab = 'tlakových tlakovým tlakové tlakovými vstupu vstupem dveří/dveřím/
        dveřích/dveřmi'
;

++ Fixture 'tlakoměr/tlakoměry/tlak' 'tlakoměr' *2
    "Jednoduchý ukazatel, v němž se mechanicky posouvá barevný pruh v okénku. Teď
        je zelený, žlutá  by znamenala malý pokles tlaku (pod 80 kPa, asi jako v
        2000 m nad mořem), oranžová nebezpečí, červená značí smrtelné riziko. "

    sightSize = small

    gcName = 'tlakoměru, tlakoměru, tlakoměr, tlakoměru, tlakoměrem'
    gcVocab = 'tlakoměru/tlakoměrem/tlakoměrů/tlakoměrům/tlakoměry/tlakoměrech/
        tlaků/tlakům/tlaky/tlacích'
;

/* ------------------------------------------------------------------------ */

+ lrPanel: PresentLater, Openable, Fixture
    'podlahový (za) panel/poklop/madla' 'podlahový panel' *2
    "<<if isOpen>>Panel je odsunutý stranou, čtyři zámky v rozích jsou
        odemčené. V místě, kde byl, zeje čtvercový otvor do podpalubí.
        <<else>>V rozích má čtyři otočné zámky držící panel na místě v
        podlaze. "

    sightSize = small

    dobjFor(Open)
    {
        preCond = static inherited + actorDirectlyInRoom
        check()
        {
            if(lrPanelLock.isLocked)
                failCheck('Panel drží pevně na svém místě. ');
        }
    }
    dobjFor(Take) asDobjFor(Open)
    dobjFor(Close)
    {
        action()
        {
            replaceAction(Lock, lrPanelLock);
        }
    }

    dobjFor(Lock) remapTo(Lock, lrPanelLock)
    dobjFor(Unlock) remapTo(Unlock, lrPanelLock)
    dobjFor(Enter) maybeRemapTo(!lrPanelLock.isLocked, Enter, lrHole)

    changeGender = 'madl:5'
    gcName = 'podlahového panelu, podlahovému panelu, podlahový panel,
        podlahovém panelu, podlahovým panelem'
    gcVocab = 'podlahového podlahovému podlahovém podlahovým panelu/panelem/
        poklopu/poklopem/madel/madlům/madlech/madly'
;

++ lrPanelLock: Lockable, Component
    'čtyři otočné zámky/zámek' 'otočné zámky' *2
    "Čtveřice otočných zámků slouží k zajištění panelu na místě. "

    isPlural = true
    sightSize = small

    dobjFor(Turn)
    {
        verify() { }
        action()
        {
            if(isLocked) replaceAction(Unlock, self);
            else replaceAction(Lock, self);
        }
    }
    dobjFor(TurnTo) asDobjFor(Turn)
    dobjFor(Move) asDobjFor(Turn)
    dobjFor(Pull) asDobjFor(Turn)

    makeLocked(stat)
    {
        inherited(stat);

        location.makeOpen(!stat);
        lrHole.makeOpen(!stat);
        unLowerDeck.moveInto(nil);

        achievement.awardPointsOnce();
    }
    dobjFor(Lock)
    {
        preCond = static inherited + actorDirectlyInRoom
        action()
        {
            "Nasadil jsi panel na otvor v podlaze a otočením všech čtyř zámků ho
                zajistil na místě. ";

            inherited;
        }
    }
    dobjFor(Unlock)
    {
        preCond = static inherited + actorDirectlyInRoom
        action()
        {
            "Postupně jsi otočil všemi čtyřmi zámky panelu, čímž se panel
                uvolnil. Panel jsi odsunul pryč a tím se ti zpřístupnil prostor
                pod podlahou. ";

            inherited;
        }
    }

    dobjFor(Open) asDobjFor(Unlock)
    dobjFor(Close) asDobjFor(Lock)

    achievement: Achievement { +3 "objevení servisní šachty" }

    gcName = 'otočných zámků, otočným zámkům, otočné zámky, otočných zámcích,
        otočnými zámky'
    gcVocab = 'otočných otočným otočnými zámků/zámkům/zámcích/zámku/zámkem'
;

+ lrHole: TravelWithMessage, HiddenDoor -> ldHole
    'prostor (pod) servisní otvor/díra/prostor/podlahou/podpalubí' 'otvor' *2
    "Panel je odsunutý stranou a v místě, kde byl, zeje čtvercový otvor do
        podpalubí. "

    travelDesc = "Nasoukal ses otvorem do nízkého prostoru pod podlahou. "

    sightSize = small

    dobjFor(ClimbDown) asDobjFor(Enter)
    dobjFor(Open) remapTo(Open, lrPanel)
    dobjFor(Close) remapTo(Close, lrPanel)

    gcName = 'otvoru, otvoru, otvor, otvoru, otvorem'
    gcVocab = 'servisního servisnímu servisním otvoru/otvorem/díru/díře/díru/
        dírou/prostoru/prostorem/podpalubím'
;

+ unLowerDeck: Unthing
    'servisní podpalubí' 'servisní podpalubí' *4
    'Usilovně přemýšlíš, kde bys měl to podpalubí hledat. Safra, kde by mohlo
        být a jak do něj najít cestu? '

    gcName = 'servisního podpalubí, servnisnímu podpalubí, servisní podpalubí,
        servisním podpalubí, servisním podpalubí'
    gcVocab = 'servisního servisnímu servisním podpalubím'
;

/* ------------------------------------------------------------------------ */

+ kitchen: Decoration
    'malá vestavěná sada kuchyň/kuchyňka/automatů/automaty'
    'vestavěná kuchyňka' *3
    "Stěna přístrojů obsahuje především mikrovlnný ohřívač jídel s průhlednými
        dvířky, nezbytnou to součást vesmírného stravování, upravený pro provoz
        ve stavu beztíže a ohřev nejrůznějších konzervovaných pochutin i
        potravinových recyklátů. "

    sightSize = small

    achievement: Achievement { +1 "snídani" }

    iobjFor(AimAt) remapTo(AimAt, DirectObject, owen)
    
    changeGender = 'autom:5'
    gcName = 'vestavěné kuchyňky, vestavěné kuchyňce, vestavěnou kuchyňku,
        vestavěné kuchyňce, vestavěnou kuchyňkou'
    gcVocab = 'malé malou vestavěné vestavěnou sady sadě sadu sadou kuchyně/
        kuchyni/kuchyní/kuchyňky/kuchyňce/kuchyňku/kuchyňkou/automatům/
        automatech'
;

++ owen: ComplexContainer, Component
    'mikrovlnný ohřívač/(jídla)' 'ohřívač jídla' *2
    "Ohřívač patří k nejdůležitějším přístrojům kosmického stravování.
        Elektromagnetickým zářením v oblasti mikrovln zahřívá obsah
        potravinových balíčků na poživatelnou teplotu. Vedle dvířek je jediný
        zapínací knoflík. "

    subContainer: ComplexComponent, OpenableContainer
    {
        maxSingleBulk = 15
        material = glass

        dobjFor(Open)
        {
            preCond = static inherited + actorDirectlyInRoom
        }
//        iobjFor(PutIn)
//        {
//            preCond = static inherited + actorDirectlyInRoom
//        }
        dobjFor(Close)
        {
            preCond = static inherited + actorDirectlyInRoom
        }
    }

    dobjFor(TurnOn)
    {
        preCond = [actorDirectlyInRoom, objClosed]
        verify() {}
        check()
        {
            if(gRevealed('ship-malfunction') && !gRevealed('ship-landed'))
                failCheck('Zkusil jsi zapnout ohřívač, ale nestalo se vůbec
                    nic. Očividně ho taky postihl výpadek napájení. ');
            if(!tube.isIn(subContainer)) failCheck('Nejprve musíš do ohřívače
                vložit pochutinu k ohřátí. ');
            if(tube.eated) failCheck('Tuba už je úplně prázdná, není co
                ohřát. ');
        }
        action()
        {
            "Zapnul jsi ohřívač, který nejprve rozpoznal vložené potraviny a
                podle toho správně zvolil režim ohřívání. Zvučné cinknutí za
                chvilku oznámilo dokončení procesu. ";

            tube.heated = true;
        }
    }

    iobjFor(AimAt)
    {
        action()
        {
            if(gRevealed('ship-malfunction') && !gRevealed('ship-landed'))
                "Namířil jsi tablet na mikrovlnný ohřívač a kamerka ho ihned
                    rozpoznala, je vypnutý. ";
            else
                "Namířil jsi tablet na mikrovlnný ohřívač a kamerka ho ihned
                    rozpoznala, je připravený k použití. ";
        }
    }

    gcName = 'ohřívače jídla, ohřívači jídla, ohřívač jídla, ohřívači jídla,
        ohřívačem jídla'
    gcVocab = 'mikrovlnného mikrovlnnému mikrovlnném mikrovlnným ohřívače/
        ohřívači/ohřívačem'
;

+++ ContainerDoor
    'dvířka (kuchyňského) (ohřívače)' 'dvířka kuchyňského ohřívače' *4
    "Jsou průhledná. Za nimi se dějí kulinářská kouzla pod taktovkou
        magnetronu. "

    iobjFor(AimAt) remapTo(AimAt, DirectObject, owen)
    
    isPlural = true
    gcName = 'dvířek kuchyňského ohřívače, dvířkám kuchyňského ohřívače,
        dvířka kuchyňského ohřívače, dvířkách kuchyňského ohřívače,
        dvířky kuchyňského ohřívače'
    gcVocab = 'dvířek dvířkám dvířkům dvířkách dvířky dvířkami -'
;

+++ Button, Component
    'zapínací knoflík' 'zapínací knoflík' *2
    "Knoflíkem se spustí ohřev jídla, který proběhne jinak zcela automaticky. "

    dobjFor(TurnOn) remapTo(TurnOn, location)
    dobjFor(Push) asDobjFor(TurnOn)
    iobjFor(AimAt) remapTo(AimAt, DirectObject, owen)
    
    gcName = 'zapínacího knoflíku, zapínacímu koflíku, zapínací knoflík,
        zapínacím knoflíku, zapínacím knoflíkem'
    gcVocab = 'zapínacího zapínacímu zapínacím knoflíku/knoflíkem'
;

+++ tube: Food 'vesmírný sendvič/tuba/pasta' 'tuba' *3
    "<<if eated>>Tuba od sendviče je vymáčknutá do posledního drobečku. <<else>>
        V tubě je napěchovaný vesmírný sendvič se šunkou a zeleninou upravený do
        podoby vymáčknutelné pasty. <<if heated>>Je prohřátý, tak akorát,
        připravený k jídlu. <<else>>Je ještě promrzlý. "

    subLocation = &subContainer
    isListed = nil

    tasteDesc = "Uždíbl jsi kousek sendvičové pasty. Není to špatné, chutná po
        pečivu se šunkou a zeleninou. "
    smellDesc = "Přičichl jsi k sendviči. Voní čerstvě navzdory dlouhému
        skladování v lodních zásobách. Potravinářská chemie dělá divy. "

    heated = nil
    eated = nil

    dobjFor(Take)
    {
        preCond()
        {
            if(isIn(location.subContainer))
                return inherited + actorDirectlyInRoom;
            else
                return inherited;
        }
    }
    dobjFor(Taste)
    {
        preCond = [actorDirectlyInRoom, touchObj]
        verify()
        {
            if(eated) illogicalNow('Tuba je už úplně prázdná. ');
        }
        check()
        {
            if(!heated) failCheck('Pasta je studená a částečně ještě zmrzlá,
                takhle by ti nechutnala. ');
        }
    }
    dobjFor(Eat)
    {
        preCond = [actorDirectlyInRoom, objHeld]
        verify()
        {
            if(eated) illogicalNow('Tuba je už úplně prázdná. ');
        }
        check()
        {
            if(!heated) failCheck('Pasta je studená a částečně ještě zmrzlá,
                takhle by ti nechutnala. ');
        }
        action()
        {
            "S chutí jsi do sebe vymačkal celý obsah tuby s vesmírným sendvičem.
                Ňam. Chutná skoro jako skutečný sendvič. ";

            eated = true;
            kitchen.achievement.awardPointsOnce();
        }
    }
    dobjFor(Push) asDobjFor(Eat)

    gcName = 'tuby, tubě, tubu, tubě, tubou'
    gcVocab = 'vesmírného vesmírnému vesmírném vesmírným sendviče/sendviči/
        sendvičem/pasty/pastě/pastu/pastou/tuby/tubě/tubu/tubou'
;

/* ------------------------------------------------------------------------ */

+ treadmill: Platform, Heavy, OnOffControl
    'posuvný běžecký pás' 'běžecký pás' *2
    "Běžná pomůcka pro udržování kondice posádky kosmických lodí. Má posuvný
        pás, přítlačné popruhy a pultík s ovládáním.
        <<treadmillDial.movementDesc()>> "

    maxSingleBulk = 10000
    sightSize = small
    isOn = treadmillDial.isOn
    allowedPostures = [standing]
    obviousPostures = [standing]

    dobjFor(StandOn)
    {
        preCond = inherited + new ObjectPreCondition(treadmillDial, objTurnedOff)
        action()
        {
            "Vlezl jsi na běžecký pás a připoutal ses přítlačnými popruhy. ";
            treadmillDial.realDistance = 0;
            inherited;
        }
    }
    dobjFor(Enter) asDobjFor(StandOn)
    dobjFor(ClimbUp) asDobjFor(StandOn)

    dobjFor(GetOutOf)
    {
        preCond = inherited + new ObjectPreCondition(treadmillDial, objTurnedOff)
        action()
        {
            "Vymotal ses z přítlačných popruhů a slezl z běžeckého pásu. ";

            if(gRevealed('ship-malfunction') && !gRevealed('ship-landed'))
            {
                "Stát na něm, když je loď z velké části bez proudu, je poněkud
                    nudné. ";
            }
            else
            {
                if(treadmillDial.realDistance > 0)
                {
                    "Jsi <<if treadmillDial.countMax > 0>>hodně<<else>>trochu<<
                        end>> zadýchaný. Ještě štěstí, že se
                        <<if gRevealed('ship-landed')>>tu dá pohybovat skoro bez
                        námahy.<<else>>v beztíži dá lodí jen proplouvat. ";

                    achievement.awardPointsOnce();
                }
            }

            gReveal('treadmill-leaved');
            inherited();
        }
    }
    dobjFor(ClimbDown) asDobjFor(GetOutOf)
    dobjFor(GetOffOf) asDobjFor(GetOutOf)

    achievement: Achievement { +1 "rozcvičku" }

    dobjFor(TurnOn) remapTo(TurnOn, treadmillDial)
    dobjFor(TurnOff) remapTo(TurnOff, treadmillDial)

    iobjFor(AimAt)
    {
        action()
        {
            "Namířil jsi tabletem na běžecký pás a kamerka ho ihned rozpoznala a
                na obrazovce zobrazila nabídku. ";

            tablet.runApp('treadmill');
        }
    }

    gcName = 'běžeckého pásu, běžeckému pásu, běžecký pás, běžeckém pásu,
        běžeckým pásem'
    gcVocab = 'posuvného posuvnému posuvném, posuvným běžeckého běžeckému
        běžeckém běžeckým pásu/pásem'
;

++ Component 'přítlačné popruhy' 'přítlačné popruhy' *2
    "Přidržují astronauta na pásu, aby neodletěl v beztíži, a zároveň silou
        přítlaku napodobují zemskou přitažlivost. "

    isPlural = true

    gcName = 'přítlačných popruhů, přítlačným popruhům, přítlačné popruhy,
        přítlačných popruzích, přítlačnými popruhy'
    gcVocab = 'přítlačných přítlačným přítlačnými popruhů/popruhům/popruzích'
;

++ treadmillPanel: Component
    'ovládací pultík (s) pultík/ovládání/ovládáním' 'pultík s ovládáním' *2
    "Je docela jednoduchý, umožnuje pouze nastavit rychlost běhu od 0 do 3
        otočením regulátoru a počítadlo ukazuje uběhnutou vzdálenost. Každý
        astronaut musí pravidelně cvičit. "

    iobjFor(AimAt) remapTo(AimAt, DirectObject, treadmill)

    gcName = 'pultíku s ovládáním, pultíku s ovládáním, pultík s ovládáním,
        pultíku s ovládáním, pultíkem s ovládáním'
    gcVocab = 'pultíku pultíkem ovládacího ovládacímu ovládacím pultíku/pultíku/
        pultíkem'
;

+++ Component 'počítadlo uběhnuté vzdálenosti/počítadlo' 'počítadlo' *4
    "Ukazuje uběhnutou vzdálenost v km. Momentálně je na něm údaj
        <<treadmillDial.counterDesc()>>. "

    iobjFor(AimAt) remapTo(AimAt, DirectObject, treadmill)

    gcName = 'počítadla, počítadlu, počítadlo, počítadle, počítadlem'
    gcVocab = 'počítadla počítadlu počítadle počítadlem počítadla/počítadlu/
        počítadle/počítadlem'
;

+++ treadmillDial: NumberedDial, Component, OnOffControl
    'otočný regulátor' 'regulátor' *2
    "Regulátor má po svém obvodu vyražená čísla od 0 do 3 a jeho otáčením se
        mění rychlost pásu. Teď je regulátor nastaven na <<curSetting>>. "

    iobjFor(AimAt) remapTo(AimAt, DirectObject, treadmill)

    minSetting = 0
    maxSetting = 3
    curSetting = '0'
    lastSetting = '0'

    isOn = curSetting != '0'

    countDistance = 0
    countMax = 0
    realDistance = 0

    counterDesc()
    {
        local l = sprintf('%.3f', treadmillDial.countDistance / 1000);
        say(l.findReplace('.', ','));
    }
    movementDesc()
    {
        switch(curSetting)
        {
        case '1':
            "Pohybuje se nízkou rychlostí. ";
            break;
        case '2':
            "Pohybuje se střední rychlostí. ";
            break;
        case '3':
            "Pohybuje se vysokou rychlostí. ";
            break;
        }
    }

    daemonId = nil
    counterDaemon()
    {
        /* Počítadlo počítá bez ohledu na to, zda na pásu stojí postava. */
        countDistance += 41.6 * (1 + parseInt(curSetting));

        if(me.isIn(treadmill))
            realDistance += 41.6 * (1 + parseInt(curSetting));

        if(me.isIn(treadmill) && curSetting == '3') countMax++;
        else countMax = 0;

        if(countMax == 3) "Stále sprintuješ, ale začínáš pomalu omdlévat a
            podlamují se ti nohy. ";

        if(countMax == 4)
        {
            "Nohy ti proklouzly za zadní okraj pásu a zůstal jsi viset na
                popruzích nad pásem. Před očima máš černé kruhy, pokoušíš se popadnout dech a
                jen koutkem oka vnímáš, jak se pás pod tebou sám pomalu zastavil. ";

            curSetting = '0';
            lastSetting = curSetting;

            if(daemonId)
            {
                daemonId.removeEvent();
                daemonId = nil;
            }
        }
    }

    dobjFor(SetTo)
    {
        verify()
        {
            inherited;

            if(gLiteral == lastSetting) illogicalAlready('Regulátor už je
                nastaven na <<curSetting>>. ');
        }
        check()
        {
            inherited;

            if(gRevealed('ship-malfunction') && !gRevealed('ship-landed'))
                failCheck('Zkusil jsi zapnout běžecký pás, ale nestalo se vůbec
                    nic. Očividně ho taky postihl výpadek napájení. ');
        }
        action()
        {
            inherited;

            local change;
            if(lastSetting == '0')
            {
                countMax = 0;

                change = 'se rozjel';
                daemonId = new Daemon(self, &counterDaemon, 1);

                gReveal('treadmill-operational');

                if(me.isIn(treadmill))
                    gReveal('treadmill-run');
            }
            else if(curSetting > lastSetting) change = 'zrychlil';
            else if(curSetting < lastSetting) change = 'zpomalil';

            switch(curSetting)
            {
            case '0':
                "Pás se pozvolna zastavil<<if me.isIn(treadmill)>> a ty s
                    ním<<end>>. ";

                if(daemonId)
                {
                    daemonId.removeEvent();
                    daemonId = nil;
                }
                break;
            case '1':
                "Pás <<change>> na nízkou rychlost. <<if me.isIn(treadmill)>>
                    Běžíš lehkým poklusem. ";
                 break;
            case '2':
                 "Pás <<change>> na střední rychlost. <<if me.isIn(treadmill)>>
                     Běžíš vytrvalostním tempem. ";
                     break;
            case '3':
                "Pás <<change>> na nejvyšší rychlost. <<if me.isIn(treadmill)>>
                    Sprintuješ na hranici svých možností. Dá ti dost zabrat, aby
                    ses na pásu udržel. ";
                 break;
            }

            lastSetting = curSetting;
        }
    }

    dobjFor(EnterOn) asDobjFor(SetTo)

    dobjFor(TurnOn)
    {
        verify()
        {
            if(curSetting != '0') illogicalAlready('Pás už je zapnutý. ');
        }
        check()
        {
            if(gRevealed('ship-malfunction') && !gRevealed('ship-landed'))
                failCheck('Zkusil jsi zapnout běžecký pás, ale nestalo se vůbec
                    nic. Očividně ho taky postihl výpadek napájení. ');
        }
        action()
        {
            "Otočil jsi regulátor na 1 a pás se rozjel na nízkou rychlost.
                <<if me.isIn(treadmill)>>Běžíš lehkým poklusem. ";

            countMax = 0;
            curSetting = '1';
            lastSetting = curSetting;

            daemonId = new Daemon(self, &counterDaemon, 1);

            gReveal('treadmill-operational');

            if(me.isIn(treadmill))
                gReveal('treadmill-run');
        }
    }

    dobjFor(TurnOff)
    {
        verify()
        {
            if(curSetting == '0') illogicalAlready('Pás už je vypnutý. ');
        }
        action()
        {
            "Otočil jsi regulátorem na nulu a pás se pozvolna
                zastavil<<if me.isIn(treadmill)>> i s tebou<<end>>. ";

            curSetting = '0';
            lastSetting = curSetting;

            if(daemonId)
            {
                daemonId.removeEvent();
                daemonId = nil;
            }
        }
    }

    gcName = 'regulátoru, regulátoru, regulátor, regulátoru, regulátorem'
    gcVocab = 'otočného otočnému otočném otočným regulátoru/regulátorem'
;
