#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/* ------------------------------------------------------------------------ */
/*
 *   KAJUTA TECHNIKA
 */
techniciansRoom: BaseRoom 'Kajuta technika' 'do kajuty technika'
    "Kajuta technika není příliš velká, ale poskytuje dostatek pohodlí a hlavně
        soukromí. Podél stěny je k podlaze připoutána postel, kousek od ní
        skříňka sloužící i jako noční stolek, na protější straně kajuty visí
        výklopný pracovní stolek. <<if supplyGrating.location>>U stropu se
        táhnou rozvody vzduchotechniky, přímo nad stolkem je větrací mřížka. "

    north = corridorEast
    out asExit(north)
    
    gender = 3
    vocabWords = '(technikovu) (borisovu) kajuta kajuty kajutě kajutu kajutou
        (technika) (borise) -'
    gcName = 'kajuty technika, kajutě technika, kajutu technika,
        kajutě technika, kajutou technika'
;

+ techniciansDoorInside: Lockable, Door -> techniciansDoor 'dveře' 'dveře' *3
    "Každá kajuta je uzavřena lehkými vzduchotěsnými a zvukotěsnými dveřmi. Měly
        by vydržet mírné výkyvy tlaku na základně. Zevnitř se dají zajistit 
        proti otevření, ale astronauti je obvykle nezamykají. "

    isPlural = true

    /* Lockable objekt by byl ve výchozím stavu zamčený, to nechceme. */
    initiallyLocked = nil
    
    dobjFor(Close)
    {
        action()
        {
            /* Boris se nedá ošálit, když hráč zavře dveře zevnitř. */
            if(technician.isIn(techniciansRoom))
                "Zavřel jsi dveře kajuty zevnitř, ale Boris se tím oklamat
                    nenechal a čeká, dokud opravdu neodejdeš. ";

            inherited;
        }
    }
    
    dobjFor(TravelVia)
    {
        action()
        {
            inherited;

            /* Postavy normálně po sobě nezavírají dveře, ale tady chceme. */
            nestedAction(Close, techniciansDoorInside);
        }
    }
    
    gcName = 'dveří, dveřím, dveře, dveřích, dveřmi'
    gcVocab = 'dveří/dveřím/dveřích/dveřmi'
;

/* ------------------------------------------------------------------------ */

+ trTable: Platform, Fixture
    'malý výklopný pracovní obdélníkový stolek/stůl' 'stolek' *2
    "Malý obdélníkový stolek na osobní věci<<if supplyGrating.location>>
        připevněný přímo pod mřížkou ventilace<<end>>. "

    maxSingleBulk = 10000
    contentsListed = nil

    dobjFor(StandOn)
    {
        check()
        {
            /* Ne před Borisovými zraky. */
            if(technician.isIn(techniciansRoom))
                failCheck('Boris vypadá opravdu hodně naštvaně, provokovat ho
                    něčím takovým v jeho kajutě asi opravdu není dobrý nápad.');
            inherited;
        }
    }
    dobjFor(ClimbUp) asDobjFor(StandOn)
    dobjFor(Enter) asDobjFor(StandOn)

    dobjFor(Open)
    {
        verify()
        {
            illogical('Raději si tu nebudeš s Borisovým stolkem hrát. ');
        }
    }
    dobjFor(Close) asDobjFor(Open)

    gcName = 'stolku, stolku, stolek, stolku, stolkem'
    gcVocab = 'malého malému malém malým výklopného výklopnému výklopném
        výklopným pracovního pracovnímu pracovním obdélníkového obdélníkovému
        obdélníkovém obdélníkovým stolku/stolkem/stolu/stolem'
;

+ trBed: Bed, Fixture 'lůžko/postel' 'lůžko' *4
    "Lůžko se podobá závěsným spacákům, jako bývají na kosmických lodích, ale je
        umístěno vodorovně a má navíc tenkou matraci. V zavěšeném spacím pytli
        by spáč přeci jen pomalu klesal k podlaze. "

    /* Do postele se má vejít jedna postava, výchozí nastavení 10000 je moc. */
    bulkCapacity = 10
    
    dobjFor(Enter) asDobjFor(LieOn)
    
    /*
     *   Potlačíme "Boris je v kajuta technika, leží na lůžku." při pohledu z
     *   ventilace.
     */
    roomActorThereDesc(actor) { }

    changeGender = 'post:3'
    gcName = 'lůžka, lůžku, lůžko, lůžku, lůžkem'
    gcVocab = 'lůžka/lůžku/lůžkem/postele/posteli/postelí'
;

++ ComplexContainer, Decoration 'tenká matrace' 'matrace' *3
    "Připomíná spíš tlustší deku. Ve zdejší nepatrné gravitaci není potřeba
        skoro nic, gravitace nestačí k tomu, aby se spáč otlačil. Matrace spíš
        jen tlumí prudší pohyby spáče, aby se ve spánku neotloukl. "

    subUnderside: ComplexComponent, Underside
    {
        bulkCapacity = 1
        contentsListed = me.isIn(techniciansRoom) && !technician.isIn(trBed)
    }

    gcName = 'matrace, matraci, matraci, matraci, matrací'
    gcVocab = 'tenké tenkou matraci/matrací'
;

/* Takové malé překvápko pro zvědavce. */
+++ Hidden, Food 'rozlehnutý placatý vysušený pavouk' 'rozlehnutý pavouk' *2
    "Pavouk je velice placatý a vysušený."

    subLocation = &subUnderside

    tasteDesc = "Opatrně jsi uždíbl kousíček pavouka. Chutná vskutku zajímavě. "
    okayEatMsg = 'S chutí jsi zchroupal celého pavouka. Byl docela hubený a
        značně vysušený, ale jistě plný proteinů a vitamínů. Ňam. '

    gcName = 'rozlehnutého pavouka, rozlehnutému pavoukovi, rozlehnutého
        pavouka, rozlehnutém pavoukovi, rozlehnutým pavoukem'
    gcVocab = 'rozlehnutého rozlehnutému rozlehnutém rozlehnutým placatého
        placatému placatém placatým vysušeného vysušenému vysušeném vysušeným
        pavouka/pavoukovi/pavoukem'
;

+ Decoration 'noční skříňka/(stolek)' 'skříňka' *3
    "Je nacpaná drobnostmi ve kterých se ti nechce přehrabovat. "

    changeGender = 'stol:2'
    gcName = 'skříňky, skříňce, skříňku, skříňce, skříňkou'
    gcVocab = 'nočního nočnímu nočním skříňky/skříňce/skříňku/skříňkou/(stolku)/
        (stolkem)'
;

++ Decoration 'různé předměty/drobnosti' 'různé předměty' *2
    "Různé osobní a pracovní drobnosti. Nic zajímavého mezi nimi není. "

    isPlural = true
    gcName = 'různých předmětů, různým předmětům, různé předměty,
        různých předmětech, různými předměty'
    gcVocab = 'různých různým různými předmětů/předmětům/předmětech'
;

/* ------------------------------------------------------------------------ */
/*
 *   Až nastane správná doba, objeví se ve hře objekty spojené s rozvody
 *   vzduchotechniky. Ve hře máme spoustu PresentLater objektů označených
 *   stejným plKey, které se pak všechny objeví najednou zavoláním
 *   PresentLater.makePresentByKey('conducts').
 */
+ trConducts: PresentLater, OutOfReach, RoomPartItem, Fixture
    'rozvody vzduchotechniky/vzduchotechnika' 'rozvody vzduchotechniky' *2
    "Rozvody se táhnou u okraje místnosti z východu na západ a právě nad stolkem
        je větrací mřížka. "

    plKey = 'conducts'

    /* Rozvody jsou na stropě. */
    specialNominalRoomPartLocation = defaultCeiling

    /* Popisek, který se objeví v rámci rozhlédnutí v místnosti. */
    specialDesc = "Pod stropem se táhnou rozvody vzduchotechniky. "

    isPlural = true
    gcName = 'rozvodů vzduchotechniky, rozvodům vzduchotechniky, rozvody
        vzduchotechniky, rozvodech vzduchotechniky, rozvody vzduchotechniky'
    gcVocab = 'rozvodů rozvodům rozvodech rozvody vzduchotechnice/
        vzduchpotechniku/vzduchotechnikou'
;

+ trGrating: PresentLater, Distant
    'větrací mřížka' 'větrací mřížka' *3
    "Přímo nad stolem je větrací mřížka rozvodů vzduchotechniky. Brání nasávání
        předmětů do rozvodů. Je poměrně velká, má rozměry cca 60×60 cm. "

    sightSize = small
    plKey = 'conducts'

    /* Hláška pro Distant třídu, nahradíme výchozí formulaci "příliš daleko". */
    tooDistantMsg = 'Mřížka je mimo tvůj dosah. '

    /* Mřížku vidíme jen z venku. */
    canBeSensed(sense, trans, ambient)
    {
        if(me.isIn(technicianConducts))
            return nil;
        else
            return inherited(sense, trans, ambient);
    }
    
    gcName = 'větrací mřížky, větrací mřížce, větrací mřížku, větrací mřížce,
        větrací mřížkou'
    gcVocab = 'mřížky/mřížce/mřížku/mřížkou'
;
