#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>
#include <date.h>

#ifdef TADS_INCLUDE_NET
    #include <tadsnet.h>
#endif

/*
 *   Objekt versionInfo je povinný objekt, který každá hra musí mít. V něm lze
 *   vyplnit řadu základních informací o hře.
 */
versionInfo: GameID

    /* Jako ISBN u knížek, generátor: http://www.tads.org/ifidgen/ifidgen */
    IFID = '29950081-477C-4628-A8F9-EC3A1AB15DCD'

    name = 'Základna na asteroidu'
    byline = 'napsali Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová'
    authorEmail = 'Tomáš Bláha <tomasb@kapsa.cz>'
    gameUrl = 'http://technoplaneta.cz/2013/'
    desc = 'Speciál pro dětskou šifrovací hru Technoplaneta '
    htmlDesc = 'Speciál pro dětskou šifrovací hru <i>Technoplaneta</i> '
    version = '2.0 z ledna 2014'
    languageCode = 'cs-CZ'
    genreName = 'Science Fiction'
    licenseType = 'Freeware'

    /* Podle Plotkinovy stupnice: Merciful, Polite, Tough, Nasty, Cruel */
    forgivenessLevel = 'Polite'

    /* Co se má stát, když hráč zadá příkaz "o hře". */
    showAbout()
    {
        "<i>Základna na asteroidu</i> vás vítá!

            <.p>Naše hra vznikla jako speciál pro poslední kolo dětské šifrovací
            hry Technoplaneta v roce 2013. Už mnoho let pro naše soutěžící
            vymýšlíme různé zapeklité šifry, tajné kódy a logické hádanky. A
            jednou nás napadlo, jaké by to asi bylo překvapení, postavit naše
            hráče před textovou hru. Textovky jsou skvělé v tom, že trénují
            čtení, cvičí pozornost a schopnost porozumět textu, odlišit
            informace důležité od nedůležitých apod. Navíc hraní v týmu by od
            našich hráčů vyžadovalo efektivní spolupráci.

            <.p>Zkrátka nápad se nám zalíbil, měl ty vlastnosti, které se na
            Technoplanetě snažíme rozvíjet, ale měl jeden háček -- jestli jsme
            chtěli uspět, museli jsme přijít se hrou, která by byla k naprostým
            začátečníkům mimořádně přátelská. Naším cílovým publikem totiž byly
            děti z duhého stupně základních škol, kteří se s tímto žánrem
            pravděpodobně nikdy nesetkali.

            <.p>Nyní přišel čas vydat vylepšenou verzi i pro širší veřejnost.
            Hra je vzhledem k cílovému publiku poměrně jednoduchá a základy
            ovládání vás sama provede v úvodní části. Přesto pokud jste na poli
            interaktivní fikce nováčky, mohl by vám přijít vhod podrobný návod
            pro hraní podobných her -- stačí jen napsat příkaz <<aHref('návod',
            'NÁVOD')>> na příkazové řádce.

            <.p>Příběh se ovládá psaním příkazů ve formě jednoduchých vět. Níže
            uvádíme základní konstrukce příkazů, kterým příběh rozumí. Ve
            skutečnosti rozumí daleko více příkazům a daleko více formám, o
            kterých se dočtete v návodu, ale účelem tohoto souhrnu je poskytnout
            stručný přehled nejdůležitějších. Místo (objekt) dosadíte název
            jakéhokoliv předmětu, který se ve hře vyskytuje. Části příkazů v
            hranatých závorkách nejsou povinné a lomítko značí alternativní
            možnosti. V rozhovorech se kromě existujících věcí dá ptát i na
            (téma) zmíněné ve hře.

            <.p>Systémové příkazy:
            <ul>
            <li>detailní skóre</li>
            <li>ulož, nahraj, vrať tah, restart</li>
            </ul>

            Pohyb a postoje hráče:
            <ul>
            <li>s, j, v, z, sv, sz, jv, jz (pohyb ve směru světových stran)</li>
            <li>levobok, pravobok, příď, záď (na palubě lodi)</li>
            <li>nahoru, dolů, dovnitř, ven (další směry)</li>
            <li>sedni/stoupni/lehni si [na (objekt)], vstaň, slez</li>
            </ul>
    
            Manipulace s věcmi:
            <ul>
            <li>inventář</li>
            <li>vem/polož (objekt), dej (objekt) do/na/za/pod (objekt)</li>
            <li>otevři/zavři/odemkni/zamkni (objekt)</li>
            <li>oblékni/obuj/svlékni/zuj (objekt)</li>
            <li>nasaď/sundej si (objekt)</li>
            </ul>
    
            Akce:
            <ul>
            <li>rozhlédni se, prozkoumej/přečti (objekt), koukni do/skrz
                (objekt)</li>
            <li>zapni/vypni (objekt)</li>
            <li>namiř na (objekt)</li>
            <li>přilož/připoj k (objektu)</li>
            <li>stiskni/pohni/zatáhni/zatlač/otoč (objekt)</li>
            <li>zadej (text) do (objektu)</li>
            <li>hledej (text) v (objektu)</li>
            <li>sněz/ochutnej/očichej (objekt)</li>
            </ul>

            Rozhovor s postavou:
            <ul>
            <li>pozdrav, rozluč se (začátek a konec rozhovoru není povinný)</li>
            <li>zeptej se na (objekt/téma), řekni o (objektu/tématu), požádej o
            (objekt), ukaž/podej (objekt)</li>
            <li>ano, ne (odpovědět na otázku položenou postavou)</li>
            <li>témata (navrhne témata, o kterých můžete mluvit, ale jen
            očividná, zdaleka ne všechna)</li>
            </ul>
    
            Navíc příběh může jednorázově nabídnout zvláštní konverzační
            možnosti mimo schéma zeptej/řekni (např. <q>Mohl by ses
            omluvit.</q>). Potom lze zadat příkaz v nabízeném tvaru rozkazovacím
            způsobem (OMLUV SE), obvykle stačí jen pár prvních slov. ";
    }

    /* Co se má stát, když hráč zadá příkaz "autoři". */
    showCredit()
    {
        "<.p>Základna na asteroidu je textová hra vytvořená Tomášem Bláhou za
            spolupráce s Pavlem Čejkou, Milanem Vančurou a Alenou Vávrovou.
            Vznikla jako speciál do dětské šifrovací hry Technoplaneta
            (http://technoplaneta.cz/) v roce 2013.

            <.p>Hra je naprogramována v systému TADS 3 od Michaela J. Robertse,
            který jsme si sami přeložili, a využívá i rozšíření <q>Subjective
            Time</q> od téhož autora a rozšíření <q>Spelling Corrector</q> od
            autorů Steva Breslina a Andrease Seweho.

            <.p>Zvláštní poděkování si zaslouží Eric Eve za skvělou dokumentaci
            a rozšíření <q>SimpleAttachable</q> a za několik vychytávek pro
            začínající hráče, které jsem si půjčil z jeho a Jimovy hry <q>Mrs.
            Pepper's Nasty Secret</q>.
            
            <.p>Na testování hry spolupracovali Kryštof Slavík, Vojta Ševčík,
            Broňa Page, Luděk Slinták, Katka Chrzová, Denisa Knížková, Jakub
            Starosta -- díky jim za všechny připomínky, které pomohly hru
            zlepšit.

            <.p>Všechny postavy ve hře jsou smyšlené a pokud vám svými názory,
            postoji či podobou někoho připomínají, je to podobnost čistě
            náhodná. ";
    }
;

/*
 *   Po úspěšném dohrání hry nabídneme volbu "doslov". To není standardní volba,
 *   takže ji musíme vyrobit.
 */
finishOptionAfterword: FinishOption
    doOption()
    {
        "<.p>Pokud jste dohráli hru bez získání plného počtu bodů, zřejmě jste
            buď nedokončili opravu lodi před odjetím ze základny nebo jste
            nesledovali stopu ohledně podezřelého kontejneru vedoucí ke
            kapitánovi. V tabletu se totiž dají získat informace o kontejneru
            a následně o jeho posledním letu, při kterém byl údajně poničen a
            vyřazen.

            <.p>Možná jste si při hraní všimli, že se tato textovka od běžných
            českých textových her trochu odlišuje. Skalní příznivci českých
            textových her se asi ze začátku divili, že nefunguje příkaz POUŽIJ,
            na který jsou zvyklí. Protože jsme tvořili primárně pro dětské hráče
            a naprosté začátečníky, bylo nám jasné, že potřebujeme hru mnohem
            přívětivější, než byly klasické textovky z osmibitů, jinak bychom
            neudrželi jejich pozornost. Mnoho inspirace jsme našli v zahraničí,
            kde textové hry v rukou nadšenců zaznamenaly velký rozvoj. Hru jsme
            naprogramovali v TADSu, jednom z nejpokročilejších systémů na tvorbu
            textových adventur, a kompletně ho adaptovali pro české prostředí.
            Tím jsme získali pevnější základy a detailnější model světa, což nám
            umožnilo s hráči komunikovat přirozeněji, blíže mluvené řeči.

            <.p>Snažili jsme se nejen o kvalitní technické zpracování, ale i o
            vymyšlení příběhu, na kterém se odrazí něco z postupů, které se
            používají u úspěšných her na světové scéně. Proto je odkrývání
            příběhu propojeno s postupem hrou a přitom se snažíme zachovat
            maximální míru volnosti pro hráče, jakým způsobem a tempem příběhem
            prochází. Také jsme se snažili vymodelovat postavy ve hře tak, aby
            měly vysokou míru interaktivity a dynamičnosti. Například Boris
            dokáže nejen poradit s opravou lodi, ale můžete se od něj dozvědět i
            řadu dalších informací důležitých v příběhu.

            <.p>Každopádně rádi uslyšíme reakce na naší hru. Dejte nám vědět, co
            se vám líbilo či kde jste měli problémy. A pokud dokonce sami
            textové hry programujete a zaujal vás způsob, jakým je naše hra
            vytvořená, rádi vám zodpovíme jakékoliv technické otázky. Koneckonců
            náš překlad TADSu je veřejně k dispozici a po nějakém čase uvolníme
            i kompletní zdrojové kódy této hry.

            <.p><tab indent=4><i><tab id=t1>Tomáš Bláha<br>
            <tab to=t1>Praha<br>
            <tab to=t1>8. ledna 2015</i>";

        /* Indikujeme, že chceme opět nabídnout menu konce hry. */
        return true;
    }

    desc = "přečíst si <<aHrefAlt('doslov', 'DOSLOV', '<b>D</b>OSLOV',
        'Ukázat doslov')>>"
    responseKeyword = 'doslov'
    responseChar = 'd'
;

/*
 *   Naopak volba zajímavých možností k vyzkoušení je standardní volbou, jen
 *   musíme poskytnout její obsah.
 */
modify finishOptionAmusing
    doOption()
    {
        "Pár věcí, které můžete také vyzkoušet:
            <.p>
            <ul>
            \n<li>Přečíst si novinové články v tabletu nebo si zahrát hru.
            \n<li>Zkusit otevřít tablet.
            \n<li>Běžet na pásu nejvyšší rychlostí a pár tahů počkat.
            \n<li>Sledovat na hodinkách, jak běží čas.
            \n<li>Otestovat tablet nebo modul bez součástek UniDiPem.
            \n<li>Povídat si s Borisem o různých tématech.
            \n<li>Ochutnat Borisovu kávu.
            \n<li>Pokusit se zabít Borise.
            \n<li>Dojít si na záchod a vykonat potřebu.
            \n<li>Povídat si s Borisem přes dveře záchoda, třeba o kafi.
            \n<li>Zkusit si odnést něco z trezoru.
            \n<li>Hýbat ručičkami nebo nožičkami figurky.
            \n<li>Kouknout se pod Borisovu matraci.
            \n<li>Přivonět k jídlu.
            \n<li>Začichat na záchodě po té, co Boris vyleze.
            \n<li>Mámit z technika identifikační kartu několikrát, zvlášť když
            ho probudíš.
            \n<li>Když probudíš Borise, tak zavřít dveře zevnitř kajuty nebo mu
            podat nějaký předmět.
            </ul>
            <.p>";

        /* Indikujeme, že chceme opět nabídnout menu konce hry. */
        return true;
    }
;

/* ------------------------------------------------------------------------ */
/*
 *   Hráč, který je zcela ztracený, by mohl zkusit požádat o nápovědu, takže se
 *   mu pokusíme pomoci. Protože máme více zdrojů informací pro pomoc v různých
 *   situacích, nabídneme mu seznam příkazů, kterými se může ke konkrétní
 *   pomoci dostat.
 */
DefineSystemAction(Help)
    execSystemAction()
    {
        "Více informací získáte kdykoliv napsáním jednoho z následujících
            příkazů na příkazové řádce:

            \b<<aHref('o hře', 'O HŘE')>> -- jak hra vznikla a stručně o jejím
            ovládání
            \n<<aHref('autor', 'AUTOR')>> -- kdo hru vytvořil a poděkování
            \n<<aHref('rady', 'RADY')>> -- vestavěné rady a nápovědy k příběhu
            \n<<aHref('návod', 'NÁVOD')>> -- podrobný návod, jak hrát
            interaktivní fikci ";
    }
;

VerbRule(Help)
    ('ukaž' | 'ukázat' | 'zobraz' | 'zobrazit' | ) ('pomoc' | 'nápověda'
    | 'nápovědu' | 'náp')
    | ('pomož' | 'napověz' | 'pomoct') ( | 'mi')
    | 'help' : HelpAction
    verbPhrase = 'ukázat/ukazu{ješ}/ukázal{a} nápovědu'
;

/* ------------------------------------------------------------------------ */
/*
 *   Ve hře používáme rošíření Subjective Time, které pohání hodinky hráče. Tato
 *   událost definuje čas na začátku hry.
 */
ClockEvent { eventTime = [1, 20, 14] }

/* ------------------------------------------------------------------------ */
/*
 *   Objekt gameMain je další povinný objekt, který hra musí mít. Knihovna volá
 *   jeho metody při spuštění hry.
 */
gameMain: GameMainDef

    /* Který objekt představuje hráče. */
    initialPlayerChar = me

    /* Zobrazení intra a titulku. */
    showIntro()
    {
        "<.p>Probudil ses ve své malé kóji zavěšený ve spacáku. Vzpomínáš na
            poslední okamžiky snu před probuzením. Zdálo se ti, jak běžíš mokrou
            trávou a při tom hlasitě dupeš, fouká vítr a ranní slunce se odráží
            na kapkách rosy.

            <.p>Už je to dávno, co jsi naposledy běžel na něčem jiném než
            trenažéru s gumovými popruhy.

            <.p>Rychlým pohledem na hodinky ses ujistil, že ti služba začne až
            za pár desítek minut a máš tak dost času na nezbytné ranní potřeby
            a rychlou snídani.\b";

        "<b>Základna na asteroidu</b>\n
            napsali Tomáš Bláha, Pavel Čejka, Milan Vančura, Alena Vávrová\n
            Vydání <<versionInfo.version>>. Pomoc získáte příkazem
            <<aHref('nápověda', 'NÁPOVĚDA')>>.\n\b";
    }

    /* Zobrazení rozloučení. */
    showGoodbye()
    {
        "<.p>Děkujeme, že jste si zahráli <i>Základnu na asteroidu</i>!\b";
    }

/*
 *   Při webovém hraní zapínáme zápis transkriptu hry. První záchytný bod je na
 *   začátku nové hry a ten druhý po automatickém obnovení uložené pozice.
 */
#ifdef TADS_INCLUDE_NET

    newGame()
    {
        local date = new Date();
        ScriptAction.performFileOp('transcript/' + date, nil);

        inherited;
    }

    restoreAndRunGame(filename)
    {
        local succ;

        /* mention that we're about to restore the saved position */
        gLibMessages.noteMainRestore();

        /* try restoring it */
        succ = RestoreAction.startupRestore(filename);

        /* show a blank line after the restore result message */
        "<.p>";

        /* if we were successful, run the game */
        if (succ)
        {
            local date = new Date();
            ScriptAction.performFileOp('transcript/' + date, nil);

            /*
             *   Run the command loop.  There's no need to show the room
             *   description, since the RESTORE action will have already
             *   done so.
             */
            runGame(nil);

            /* show the end-of-game message */
            showGoodbye();
        }
    }

#endif
;

/* ------------------------------------------------------------------------ */
/*
 *   Při webovém hraní redefinujeme pár systémových tříd, abychom v nich přidali
 *   funkci automatického ukládání pozice po zavření prohlížeče. Také ukončujeme
 *   zápis transkriptu hry, aby se stihl uložit na storage server a nezůstal jen
 *   v dočasném souboru.
 *
 *   Také vypneme možnost konce hry v menu po dohrání hry.
 */
#ifdef TADS_INCLUDE_NET

   /*
    *   Housekeeping interval.  We'll wait at least this long between
    *   housekeeping passes...
    */
    #define HousekeepingInterval  15000

   /*
    *   Session startup timeout.  When we first start up, we'll give our first
    *   client this long to establish a connection.  If we don't hear anything
    *   from a client within this interval, we'll assume that the client
    *   exited before it had a chance to set up its first connection, so we'll
    *   terminate the server.
    */
    #define SessionStartupTimeout  90000

   /*
    *   Ongoing session timeout.  After we've received our first connection,
    *   we'll terminate the server if we go this long without any active
    *   connections...
    */
    #define SessionTimeout  120000

    modify webSession
        /*
         *   Run housekeeping tasks.  The network event processor calls this
         *   periodically to let us perform background cleanup tasks.  Returns
         *   the system tick time of the next housekeeping run...
         */
        housekeeping()
        {
            /*.
             *   if it hasn't been long enough yet since the last housekeeping
             *   run, skip this.
             */
            if (getTime(GetTimeTicks) < hkTime)
                return hkTime;

            /* send keep-alives and check for dead client sessions */
            clientSessions.forEach(function(s)
            {
                /* send keep-alives to aged-out event requests */
                s.sendKeepAlive();

                /* check to see if the client has disconnected */
                s.checkDisconnect();
            });

            /* if there are no client sessions, check for server termination */
            if (clientSessions.length() == 0)
            {
                /*.
                 *   There are no clients connected.  If we've exceeded the
                 *   maximum interval for running without a client, shut down
                 *   the server.  Use the initial connection time limit if
                 *   we've never had a client, otherwise use the ongoing idle
                 *   time limit...
                 */
                local limit = everHadClient
                    ? SessionTimeout : SessionStartupTimeout;

                if (getTime(GetTimeTicks) > lastClientTime + limit)
                {
                    /*
                     *   Here is the right spot to perform autosave. Originally
                     *   I've tried calling save in GameMainDef.newGame() just
                     *   after inherited funcionality. But while it is good
                     *   to start and end automatic scripting, its probably too
                     *   late for saving game state. Such save is created, but
                     *   cannot be loaded.
                     */
                    ScriptOffAction.turnOffScripting(nil);
                    SaveAction.performFileOp('autosave.t3v', nil);

                    /* no clients - shut down */
                    throw new QuittingException();
                }
            }
            else
            {
                /* we have a session as of right now */
                lastClientTime = getTime(GetTimeTicks);
            }

            /* update the housekeeping timer */
            return hkTime = getTime(GetTimeTicks) + HousekeepingInterval;
        }
    ;

    /* Při restartu ukončíme předchozí zápis trenskriptu hry. */
    modify RestartAction
        doRestartGame()
        {
            ScriptOffAction.turnOffScripting(nil);
            inherited;
        }
    ;

/* Když hrály děti soutěžně, byl na webu žebříček v reálném čase. */
//    modify addToScore(points, desc)
//    {
//        /* simply call the libScore method to handle it */
//        libScore.addToScore_(points, desc);

//        local text = mainOutputStream.captureOutput({: desc.desc() });

//        local data =
//        [
//            'sid' -> webSession.storageSID,
//            'event' -> 'score',
//            'points' -> points,
//            'desc' -> text,
//            'total' -> libScore.totalScore
//        ];

//        sendNetRequest(0, 'http://technoplaneta.cz/t3submit', 'POST', 0, nil,
//            data);
//    }


    /*
     *   Finish the game, showing a message explaining why the game has ended.
     *   This can be called when an event occurs that ends the game, such as
     *   the player character's death, winning, or any other endpoint in the
     *   story.
     *
     *   We'll show a message defined by 'msg', using a standard format.  The
     *   format depends on the language, but in English, it's usually the
     *   message surrounded by asterisks: "*** You have won! ***".  'msg' can
     *   be:
     *
     *.    - nil, in which case we display nothing
     *.    - a string, which we'll display as the message
     *.    - a FinishType object, from which we'll get the message
     *
     *   After showing the message (if any), we'll prompt the user with
     *   options for how to proceed.  We'll always show the QUIT, RESTART, and
     *   RESTORE options; other options can be offered by listing one or more
     *   FinishOption objects in the 'extra' parameter, which is given as a
     *   list of FinishOption objects.  The library defines a few non-default
     *   finish options, such as finishOptionUndo and finishOptionCredits; in
     *   addition, the game can subclass FinishOption to create its own custom
     *   options, as desired.
     */
    replace finishGameMsg(msg, extra)
    {
        local lst;

        /*
         *   Adjust the turn counter to take into account the action currently
         *   in progress, if any, and to reflect any turns that the player
         *   character has already completed and which aren't yet reflected in
         *   the turn counter.  If we're processing a daemon, the PC's next
         *   schedulable run time will already reflect the last turn the PC
         *   completed, but the global turn counter won't be there yet, since
         *   we're still scheduling daemons that were ready to run on the same
         *   turn as the player's last action.
         */
        libGlobal.totalTurns = gPlayerChar.nextRunTime + gAction.actionTime;

        /*
         *   Explicitly run any final score notification now.  This will ensure
         *   that any points awarded in the course of the final command that
         *   brought us to this point will generate the usual notification, and
         *   that the notification will appear at a reasonable place, just
         *   before the termination message.
         */
        if (libGlobal.scoreObj != nil)
            libGlobal.scoreObj.runScoreNotifier();

        /* translate the message, if specified */
        if (dataType(msg) == TypeObject)
        {
            /* it's a FinishType object - get its message property or string */
            msg = msg.finishMsg;

            /* if it's a library message property, look it up */
            if (dataType(msg) == TypeProp)
                msg = gLibMessages.(msg);
        }

        /* if we have a message, display it */
        if (msg != nil)
            gLibMessages.showFinishMsg(msg);

        /* if the extra options include a scoring option, show the score */
        if (extra != nil && extra.indexWhich({x: x.showScoreInFinish}) != nil)
        {
            "<.p>";
            libGlobal.scoreObj.showScore();
            "<.p>";
        }

        /*
         *   Since we need to interact directly with the player, any sense
         *   context currently in effect is now irrelevant.  Reset the sense
         *   context by setting the 'source' object to nil to indicate that we
         *   don't need any sense blocking at all.  We can just set the context
         *   directly, since this routine will never return into the
         *   surrounding command processing - we always either terminate the
         *   program or proceed to a different game context (via undo, restore,
         *   restart, etc).  By the same token, the actor we're talking to now
         *   is the player character.
         */
        senseContext.setSenseContext(nil, sight);
        gActor = gPlayerChar;

        /* start with the standard options */
        lst = [finishOptionRestore, finishOptionRestart];

        /* add any additional options in the 'extra' parameter */
        if (extra != nil)
            lst += extra;

        /* always add 'quit' as the last option */
    //    lst += finishOptionQuit;

        /* process the options */
        processOptions(lst);
    }

#endif

/* ------------------------------------------------------------------------ */
/*
 *   Nahodilé EventListy poněkud ztrpčují automatické testování. Jakmile vznikne
 *   malá změna, třeba se přidá nějaký krok navíc, všechny se přesypou a hodí
 *   jinou hlášku. V debug režimu tedy jejich nahodilost potlačíme.
 */
#ifdef __DEBUG

modify ShuffledEventList
    doScript()
    {
        local bak = curScriptState;
        inherited();
        curScriptState = bak;
    }
;

#endif

/* ------------------------------------------------------------------------ */
/*
 *   Pár vyřazených příkazů. Nahradíme jejich VerbRule prázdnou, aby se nemohly
 *   nikdy použít.
 */

/* Plete se s "otoč zámky na panelu" */
replace VerbRule(TurnWithType2)
    '': TurnToAction
;

/*
 *   Na webu nechceme příkaz konec, ukončil by se interpretr a uložila se
 *   ukončená hra, která nejde restartovat. Stačí když hráč zavře okno.
 */
#ifdef TADS_INCLUDE_NET

replace VerbRule(Quit)
    '': QuitAction
;

#endif

/*
 *   Dokud nevyjde oprava chyby http://bugdb.tads.org/view.php?id=232 tak
 *   vypneme příkaz "pauza". Na webu dělá neplechu.
 */
replace VerbRule(Pause)
    ()
    : PauseAction
;

/* ------------------------------------------------------------------------ */
/*
 *   Oprava chyby #228 od Emily Boegheim.
 */
modify NounPhraseWithVocab
    /*
     * Run a set of resolved objects through matchName() or a similar
     * routine. Returns the filtered results.
     */
    resolveNounsMatchName(results, resolver, matchList)
    {
        local origTokens;
        local adjustedTokens;
        local objVec;
        local ret;

        /* get the original token list for the command */
        origTokens = getOrigTokenList();

        /* get the adjusted token list for the command */
        adjustedTokens = getAdjustedTokens();

        /* set up to receive about the same number of results as inputs */
        objVec = new Vector(matchList.length());

        /* consider each preliminary match */
        foreach (local cur in matchList)
        {
            /* ask this object if it wants to be included */
            local newObj = resolver.matchName(
                cur.obj_, origTokens, adjustedTokens);

            /* check the result */
            if (newObj == nil)
            {
                /*
                 * it's nil - this means it's not a match for the name
                 * after all, so leave it out of the results
                 */
            }
            else if (newObj.ofKind(Collection))
            {
                /*
                 * it's a collection of some kind - add each element to
                 * the result list, using the same flags as the original
                 */
                foreach (local curObj in newObj)
                    objVec.append(new ResolveInfo(curObj, cur.flags_, self));
            }
            else
            {
                /*
                 * it's a single object - add it ito the result list,
                 * using the same flags as the original
                 */
                objVec.append(new ResolveInfo(newObj, cur.flags_, self));
            }
        }

        /* convert the result vector to a list */
        ret = objVec.toList();

        /* if our list is empty, note it in the results */
        if (ret.length() == 0)
        {
            /*
             * If the adjusted token list contains any tokens of type
             * "miscWord", send the phrase to the results object for
             * further consideration.
             */
            if (adjustedTokens.indexOf(&miscWord) != nil)
            {
                /*
                 * we have miscWord tokens, so this is a miscWordList
                 * match - let the results object process it specially.
                 */
                ret = results.unknownNounPhrase(self, resolver);
            }

            /* THIS IS THE NEW BIT */
            if (!ret)
                ret = [];

            /*
             * if the list is empty, note that we have a noun phrase
             * whose vocabulary words don't match anything in the game
             */
            if (ret.length() == 0)
                results.noVocabMatch(resolver.getAction(), getOrigText());
        }

        /* return the result list */
        return ret;
    }
;
