#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/* ------------------------------------------------------------------------ */
/*
 *   VESMÍRNÁ LOĎ
 */

/*
 *   Objekt reprezentující celou loď, protože se na ní hráč může ptát nebo ji
 *   chtít prozkoumat. Použijeme proto MultiLoc, která umožní, aby jeden
 *   faktický objekt se nacházel ve všech lokacích.
 *
 *   Kromě MultiLoc existují ještě MultiInstance a MultiFaceted, které
 *   reprezentují trochu jiné případy. Sice by se zdálo, že MultiFaceted je
 *   vhodnější, ale ve skutečnosti hráč o lodi vždy uvažuje jako o celku a nijak
 *   s ní nemůže manipulovat, takže MultiLoc stačí.
 */
ship: MultiLoc, Fixture
    'vesmírná vesmírné kosmická kosmické loď/konzerva/plavidlo/trup'
    'vesmírná loď' *3
    "Kosmická loď je standardní tahač nákladů používaný k dálkovým letům ve
        sluneční soustavě. Výbava i zařízení je jen o maličko méně spartánské,
        než bývá v lodích na krátkých trasách. Navzdory vysoce efektivnímu
        pohonu se stále společnosti snaží šetřit každý kilogram hmotnosti ve
        prospěch nákladu. "

    cannotTakeMsg = 'Chytl ses nejbližšího madla, ale po chvilce tě to omrzelo a
        loď jsi zas odložil. '
    cannotMoveMsg = 'Opřel ses o jednu ze vzpěr ramenem, ale loď je o mnoho
        těžší než ty a ty se nemáš se o co opřít, ani nemáš vlastní pohon. '
    cannotPutMsg = 'Chytl ses nejbližšího madla ve snaze lodí pohnout, ale po
        chvilce tě to omrzelo a loď jsi zas odložil. '

    /* Ve kterých místnostech se objekt nachází. */
    initialLocationClass = ShipboardRoom

    /* Loď by neměla být zahrnuta, když řekneš např. "seber vše" */
    hideFromAll(action) { return true; }

    /*
     *   Jakmile hráč převezme službu, načasujeme na tři tahy nehodu.
     */
    malfunctionFuse = nil
    sayMalfunction()
    {
        "<.p><center>* * * * *</center>
            <.p>Od převzetí služby uplynulo něco přes hodinu, když párkrát
            zablikala světla a některé přístroje se zjevně restartovaly. Pak se
            ozvalo velmi tlumené dvojité prásknutí rychle po sobě, jako vzdálené
            výstřely odněkud z trupu lodi a světla zhasla zcela.
            <.p>Po chvilce se rozsvítilo nouzové osvětlení.
            <.p><q>Ksakru!</q>, na tohle vás cvičili, ale realita ve vesmírné
            prázdnotě je vždycky děsivější. Naštěstí výcvik zapracoval dřív, než
            sis začal představovat možné konce.
            <.p>Zkontroloval jsi tlakoměr v kabině, ale tlak se nemění, a na
            počítači nezávislý alarm signalizující netěsnost trupu se taky
            neozývá, výstražně pípá jen záložní zdroj napájení. Alespoň, že tak.
            Třeba je ještě nějaká naděje. ";

        gReveal('ship-malfunction');

        treadmill.curSetting = '0';
        treadmill.lastSetting = curSetting;

        if(daemonId)
        {
            daemonId.removeEvent();
            daemonId = nil;
        }

        clock.eventReached();
    }
    clock: ClockEvent { eventTime = [1, 22, 13] }

    dobjFor(Repair)
    {
        action()
        {
            "<<if gRevealed('ship-malfunction') && !gRevealed('ship-fixed')>>
                Usilovně se snažíš vzpomenout, jak se to dělá. Asi jsi měl v
                pilotní škole dávat více pozor. Možná se někde povaluje příručka
                k lodi, tam by mohly být servisní postupy popsané.
                <<else>>Loď je zcela v pořádku. ";
        }
    }

    changeGender = 'plavi:4, trup:2'
    gcName = 'vesmírné lodi, vesmírné lodi, vesmírnou loď, vesmírné lodi,
        vesmírnou lodí'
    gcVocab = 'vesmírné vesmírnou vesmírného vesmírnému vesmírném vesmírným
        lodi/lodí/konzervy/konzervě/konzervu/konzervou/plavidla/plavidlu/
        plavidlem/APL-21/APL-22/APL21/APL22/trupu/trupem'
;

/* ------------------------------------------------------------------------ */
/*
 *   Po nehodě jsou v atmosférických hláškách občas zmíněné objekty, které je
 *   lepší poskytnout, kdyby je hráč zkoumal.
 */
MultiLoc, SimpleNoise 'záložní zdroj/napájení/alarm' 'záložní zdroj' *2
    "<<if gRevealed('ship-malfunction') && !gRevealed('ship-landed')>>
        Hvízdání alarmu zní velmi varovně a jeho zvuk rozhodně pobízí k rychlému
        řešení problému. Už jsi zkoumal palubní desku a přístroje na ní?
        <<else>>
        Záložní zdroj je v pořádku, alarm je potichu. "

    initialLocationClass = ShipboardRoom
    
    gcName = 'záložního zdroje, záložnímu zdroji, záložní zdroj,
        záložním zdroji, záložním zdrojem'
    gcVocab = 'záložního záložnímu záložním zdroje/zdroji/zdrojem/alarmu/
        alarmem'
;

MultiLoc, Decoration 'dozimetr' 'dozimetr' *2
    "Občasné tikání dozimetru není nic neobvyklého, radiace je běžnou součástí
        života ve vesmíru. "

    initialLocationClass = ShipboardRoom

    gcName = 'dozimetru, dozimetru, dozimetr, dozimetru, dozimetrem'
    gcVocab = 'dozimetru/dozimetrem'
;

MultiLoc, Decoration 'ventily rekuperace vody/ventily' 'ventily' *2
    "Občasné cvakání ventilů není nic neobvyklého, palubní systémy jsou sice
        složité, ale většina jich pracuje plně automaticky. "

    initialLocationClass = ShipboardRoom

    isPlural = true
    gcName = 'ventilů, vetilům, ventily, ventilech, ventily'
    gcVocab = 'ventilů vetilům ventilech ventilů/vetilům/ventilech'
;

MultiLoc, Decoration 'slunce' 'slunce' *4
    "Slunce je daleko a loď se od něj vzdaluje, takže ani není šance ho
        zahlédnout z průzoru v pilotní kabině. "

    initialLocationClass = ShipboardRoom

    isPlural = true
    gcName = 'slunce, slunci, slunce, slunci, sluncem'
    gcVocab = 'slunci/sluncem'
;

MultiLoc, Decoration 'topení' 'topení' *4
    "<<if gRevealed('ship-malfunction') && !gRevealed('ship-landed')>>Topení
        nemůžeš zapnout, řídí ho automatika lodi, jeho vypnutí naznačuje mnohem
        vážnější poruchu.
        <<else>>Regulaci teploty řídí automatika lodi. Není potřeba topení
        ovládat ručně. "

    initialLocationClass = ShipboardRoom

    dobjFor(TurnOn) asDobjFor(Examine)

    gcName = 'topení, topení, topení, topení, topením'
    gcVocab = 'topením'
;

/* ------------------------------------------------------------------------ */
/*
 *   Části místností (podlaha, strop a stěny) na palubě vesmírné lodi jsou
 *   velmi specifické a tak si zaslouží svůj popis. Už proto, že např. podlaha
 *   ve společenské místnosti má mít na podlaze průchod do podpalubí a tak se
 *   hodí podlahu neučinit bezvýznamnou pomocí standardní hlášky.
 */
shipFloor: Floor 'podlaha/panel/polyuretan/zem' 'podlaha' *3
    "Podlaha je složená ze čtvercových panelů pokrytých měkkým pružným
        polyuretanem. Dobře tlumí zvuky, které by se jinak nesly celou lodí. "

    objIntoCase = 4
    sightSize = small

    changeGender = 'polyuretan:2, panel:2'
    gcName = 'podlahy, podlaze, podlahu, podlaze, podlahou'
    gcVocab = 'podlahy/podlaze/podlahu/podlahou/panelu/panelem/polyuretanu/
        polyuretanem/země/zemi/zemí'
;

shipCeiling: RoomPart 'strop' 'strop' *2
    "Strop je pokrytý panely z odolného plastu. Po celé délce místnosti jsou
        okolo stropních panelů osvětlovací pásy. "

    sightSize = small

    gcName = 'stropu, stropu, strop, stropu, stropem'
    gcVocab = 'stropu/stropem'
;

shipLights: RoomPart, Decoration
    'osvětlovací elektroluminiscenční pásy/osvětlení' 'osvětlovací pásy' *2
    "Stropní osvětlení je tvořeno elektroluminiscenčními pásy, jsou úsporné,
        není snadné je poškodit a vydrží dlouho. No, svítí to, na čtení to není,
        ale stačí to k tomu, aby sis nenatloukl nos. "

    isPlural = true
    sightSize = small

    gcName = 'osvětlovacích pásů, osvětlovacím pásům, osvětlovací pásy,
        osvětlovacích pásech, osvětlovacími pásy'
    gcVocab = 'osvětlovacích osvětlovacím osvětlovacími elektroluminiscenčních
        elektroluminiscenčním elektroluminiscenčními pásů/pásům/pásy/pásech'
;

shipVents: RoomPart, Decoration
    'mřížka mřížky vzduchotechniky/vzduchotechnika' 'mřížky vzduchotechniky' *3
    "Mřížky vzduchotechniky slouží k větrání, trvale jimi proudí recyklovaný
        vzduch. Na filtrech se občas zachytávají různé drobné zapomenuté
        předměty plující vzduchem, ale zrovna teď na nich nic není. "

    sightSize = small

    isPlural = true
    gcName = 'mřížek vzduchotechniky, mřížkám vzduchotechniky, mřížky
        vzduchotechniky, mřížkách vzduchotechniky, mřížkami vzduchotechniky'
    gcVocab = 'mřížek mřížkám mřížkách mřížkami vzduchotechnice/vzduchotechniku/
        vzduchotechnikou'
;

shipVents2: RoomPart, Decoration 'ventilace' 'ventilace' *3
    "Ventilace zajišťuje přísun recyklovaného vzduchu. "

    sightSize = small

    gcName = 'ventilace, ventilaci, ventilaci, ventilaci, ventilací'
    gcVocab = 'ventilaci/ventilací'
;

shipRecycler: RoomPart, Decoration
    'recyklační jednotka' 'recyklační jednotka' *3
    "Recyklační jednotka udržuje důležitý koloběh vzduchu, vody i dalšího
        odpadu. Čistí, obohacuje, separuje a vrací zpět do oběhu. "

    sightSize = small

    gcName = 'recyklační jednotky, recyklační jednotce, recyklační jednotku,
        recyklační jednotce, recyklační jednotkou'
    gcVocab = 'jednotky/jednotce/jednotku/jednotkou'
;

portWall: DefaultWall
    'levá zeď/přepážka/stěna*zdi*přepážky*stěny' 'levá stěna' *3
    "Stěna je pokrytá odolným světlým plastem. "

    sightSize = small

    gcName = 'levé stěny, levé stěně, levou stěnu, levé stěně, levou stěnou'
    gcVocab = 'levé levou zdi/zdí/přepážky/přepážce/přepážku/přepážkou/stěny/
        stěně/stěnu/stěnou*zdí*zdím*přepážek*přepážkám*přepážkách*přepážkami*
        stěn*stěnám*stěnách*stěnami'
;

starboardWall: DefaultWall
    'pravá zeď/přepážka/stěna*zdi*přepážky*stěny' 'pravá stěna' *3
    "Stěna je pokrytá odolným světlým plastem. "

    sightSize = small

    gcName = 'pravé stěny, pravé stěně, pravou stěnu, pravé stěně,
        pravou stěnou'
    gcVocab = 'pravé pravou zdi/zdí/přepážky/přepážce/přepážku/přepážkou/stěny/
        stěně/stěnu/stěnou*zdí*zdím*přepážek*přepážkám*přepážkách*přepážkami*
        stěn*stěnám*stěnách*stěnami'
;

aftWall: DefaultWall
    'zadní zeď/přepážka/stěna*zdi*přepážky*stěny' 'zadní stěna' *3
    "Stěna je pokrytá odolným světlým plastem. "

    sightSize = small

    gcName = 'zadní stěny, zadní stěně, zadní stěnu, zadní stěně, zadní stěnou'
    gcVocab = 'zdi/zdí/přepážky/přepážce/přepážku/přepážkou/stěny/stěně/stěnu/
        stěnou*zdí*zdím*přepážek*přepážkám*přepážkách*přepážkami*stěn*stěnám*
        stěnách*stěnami'
;

foreWall: DefaultWall
    'přední zeď/přepážka/stěna*zdi*přepážky*stěny' 'přední stěna' *3
    "Stěna je pokrytá odolným světlým plastem. "

    sightSize = small

    gcName = 'přední stěny, přední stěně, přední stěnu, přední stěně,
        přední stenou'
    gcVocab = 'zdi/zdí/přepážky/přepážce/přepážku/přepážkou/stěny/stěně/stěnu/
        stěnou*zdí*zdím*přepážek*přepážkám*přepážkách*přepážkami*stěn*stěnám*
        stěnách*stěnami'
;

/* ------------------------------------------------------------------------ */
/*
 *   Na palubě (nejen) vesmírné lodi nedává smysl chodit ve směru světových
 *   stran, protože loď v prostoru manévruje a ta vesmírná je navíc během
 *   letu i mimo jakýkoliv svět. Proto jako základ našich místností použijeme
 *   třídu ShipboardRoom, která přidává možnost pohybu ve směrech platných na
 *   palubě lodi (levobok, pravobok, příď, záď).
 */
modify ShipboardRoom
    /*
     *   ShipboardRoom pouze přidává směry, ale ty ve směru světových stran jsou
     *   stále k dispozici a tak je zablokujeme. Pokud se je hráč pokusí použít,
     *   vysvětíme mu, jak se má pohybovat.
     */
    north: NoTravelMessage { "Tento směr tu nedává smysl. Na palubě lodi můžeš
        jít na levobok (LB), pravobok (PB), příď (PD) nebo na záď (ZD). " }

    south asExit(north)
    east asExit(north)
    west asExit(north)
    northeast asExit(north)
    northwest asExit(north)
    southeast asExit(north)
    southwest asExit(north)

    /*
     *   Na palubě vesmírné lodi nechceme části běžné místnosti jako stěny ve
     *   směrech světových stran, které jsme si z Room přinesli. Proto části
     *   předefinujeme podle svého.
     */
    roomParts = [shipFloor, shipCeiling, shipLights, shipVents, shipVents2,
        shipRecycler, portWall, starboardWall, aftWall, foreWall]

    /*
     *   Atmosféru na lodi budeme dokreslovat řadou hlášek, které se musejí
     *   přepnout na depresivní variantu, jen co dojde k poruše.
     */
    atmosphereList = gRevealed('ship-landed') ? nil : (gRevealed(
        'ship-malfunction') ? malfunctionAtmosphere : normalAtmosphere)

    normalAtmosphere: ShuffledEventList
    {
        [
            'Ozvalo se tlumené zacvakání přepouštěcích ventilů rekuperace
                vody. ',
            'Chvilku jsi naslouchal spokojenému vrnění recyklační jednotky.
                Dobře fungující přístroje příjemně uklidňují. ',
            '<q>Uááh,</q> zívl jsi. Funění ventilace občas uspává. ',
            'Krátce zatikal palubní dozimetr. Slunce je už docela daleko, ale
                občas reaguje na radiaci ze vzdálených pulzarů, částice
                urychlené černými dírami a jiné atomové smetí. ',
            '<q>Whůůům…</q> loď na chvíli zapnula motory. V inertním poli
                není zrychlení cítit, ale přesto se vibrace nesou celým trupem
                a jsou slyšet. ',
            'Tiše cvaklo relé regulace ochranného magnetického pole, které
                odklání alespoň část vysokoenergetických částic, jimiž se volný
                vesmír doslova hemží. '
        ]
        eventPercent = 50
        eventReduceAfter = 12
        eventReduceTo = 20
    }

    malfunctionAtmosphere: ShuffledEventList
    {
        /* Atmosféru nechceme zobrazit ve stejném tahu, kdy dojde k nehodě. */
        [ nil ]
        [
            'Mlčení palubních přístrojů nahání hrůzu, otřásl ses. ',
            'Ozvalo se zlověstné zaskřípání chladnoucího trupu. Slunce je daleko
                a bez topení tu bude za pár hodin mrznout. ',
            'Hlasitě zahvízdal alarm záložního zdroje, který napájí nouzové
                osvětlení a generátor kyslíku. ',
            'Slyšíš jen vlastní nervózní dech. I tlukot srdce ti připadá
                nepatřičně hlasitý. '
        ]
        eventPercent = 50
        eventReduceAfter = 8
        eventReduceTo = 20
    }
    
    pressure = 1
;

/* ------------------------------------------------------------------------ */
/*
 *   Pár smyslových objektů, odpovídající na příkazy čichej a poslouchej.
 */
MultiLoc, SimpleOdor
    initialLocationClass = ShipboardRoom
    desc = "Nasál jsi vzduch. Hmmm, ano, je cítit přesně tak, jako malý prostor,
        který obývají dlouho dva lidé a vzduch se neustále recykluje levnými
        filtry recyklační jednotky. "
;

MultiLoc, SimpleNoise
    initialLocationClass = ShipboardRoom
    desc = gRevealed('ship-malfunction') ? "Zaposlouchal ses do zlověstného
        ticha pravidelně rušeného kvičením alarmu záložního zdroje.
        V takové chvíli se pustá, nehostinná, mrazivá, vše obklopující a smrtící
        prázdnota vesmíru zdá být blíž než kdykoli jindy. " : "Zaposlouchal ses
        do uklidňujícího šumění zapnutých přístrojů, někdy zní, jako by sama loď
        pulzovala pomalým životem, jindy zas jak tichá elektromechanická
        harmonie, jejíž tóny nelze rozpoznat. "
;

/* ------------------------------------------------------------------------ */
/*
 *   Kokpit se společenskou místností jsou porpojeny smyslovými konektory, aby
 *   bylo vidět, co se ve druhé místnosti děje. Popisujeme hlavně postavy, tj.
 *   aby hráč věděl, že je v kokpitu kapitán a až převezme službu, aby ho slyšel
 *   odcházet si lehnout.
 */
DistanceConnector [cockpit, livingRoom]
    transSensingThru(sense) { return (sense == sound ? opaque : (cDoor.isOpen ?
        distant : opaque)); }
;
