#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/* ------------------------------------------------------------------------ */
/*
 *   PŘECHODOVÁ KOMORA
 */
airlock: Room 'Přechodová komora' 'do přechodové komory'
    "Přechodová komora je opravdu těsná. S obtížemi by se do ní vešli dva lidé
        ve skafandrech. Vyčerpání vzduchu není nikdy dokonalé, stojí energii a
        ztracenou atmosféru je nutné doplnit. Proto se tento výstup do volného
        prostoru používá jen v nezbytných případech. Dvojice pák ovládá
        vzduchotěsné dveře a trojice ciferníků měří tlak vzduchu uvnitř a vně
        přechodové komory.<.reveal hint-airlock-visited> "

    west = airlockInnerDoor
    in asExit(west)
    east = airlockOuterDoor
    out asExit(east)

    pressure = 1

    gender = 3
    vocabWords = 'přechodová přechodové přechodovou komora/komory/komoře/komoru'
    gcName = 'přechodové komory, přechodové komoře, přechodovou komoru,
        přechodové komoře, přechodovou komorou'
;

/* IndirectDoor je třída pro dveře ovládané pákou, viz regionBasr.t. */
+ airlockInnerDoor: IndirectDoor
    'vnitřní západní vzduchotěsné tlakové dveře/(dovnitř)' 'vnitřní dveře' *3
    "Vypadají jako běžné tlakové dveře, natřené čistě bílou, s kovovými
        výztuhami a maličkým okénkem. Ovládají se pákou na stěně. "

    initiallyOpen = true

    isPlural = true
    gcName = 'vnitřních dveří, vnitřním dveřím, vnitřní dveře, vnitřních
        dveřích, vnitřními dveřmi'
    gcVocab = 'vnitřních vnitřním vnitřními západních západním západními
        vzduchotěsných vzduchotěsným vzduchotěsnými tlakových tlakovým tlakovými
	dveří/dveřím/dveřích/dveřmi'
;

/*
 *   Okénko dveří je detail přidaný z důvodu kompletnosti, ale ve skutečnosti
 *   není vůbec důležité. Protože má podobný slovník jako jeho dveře (okénko
 *   vnitřních dveří vs. vnitřní dveře), mohlo by se zbytečně plést a hra by se
 *   mohla zbytečně ptát, co má hráč na mysli. Proto jakmile hra přemýšlí, jaký
 *   objekt hráč v příkazu myslel a mezi možnými předměty je jak okénko, tak
 *   jeho dveře, potom okénko samo sebe odstraní ze seznamu shodujících se
 *   předmětů díky aplikaci třídy ComponentDeferrer.
 */
++ ComponentDeferrer, Component
    'vnitřní maličké okénko vnitřních dveří sklo -*okénka*skla'
    'okénko vnitřních dveří' *4
    "Je to jen malý průzor velikosti dlaně s tlustým a odolným sklem. "

    /*
     *   No jó, no. Člověk musí přemýšlet o každé blbosti, kterou bude chtít
     *   hráč provést. Ale je skvělé, když má hra hlubokou implementaci a i
     *   napodruhé najde člověk nové věci a vtípky.
     */
    shouldNotBreakMsg = 'Chvíli jsi nad rozbitím uvažoval, ale když sis
        představil, jak dopadla poslední rvačka v kosmickém baru… Brrr, střepy
        v… raději ani nemyslet. '

    dobjFor(LookThrough)
    {
        verify()
        {
            if(location.isOpen())
                illogicalNow('Dveře jsou zasunuty ve stěně komory, takže okénko
                    je teď schované. ');
        }
        action ()
            { "Odsud je jím vidět do kupole. "; }

    }
    dobjFor(LookIn) asDobjFor(LookThrough)

    gcName = 'okénka vnitřních dveří, okénku vnitřních dveří, okénko vnitřních
        dveří, okénku vnitřních dveří, okénkem vnitřních dveří'
    gcVocab = 'maličkého maličkému meličkém maličkým okénka okénku okénkem skla
        sklu sklem -*okének*okénkám*okénkách*okénky*okénkama*okénkami'
;

+ Enterable -> airlockInnerDoor 'kupole/kopule' 'kupole' *3
    "Kupole je část základny nad povrchem, do které vede přechodová komora, kde
        právě stojíš. "

    /* Kupole určitě není kandidátem na "vem vše" apod. */
    hideFromAll(action) { return true; }
    
    gcName = 'kupole, kupoli, kupoli, kupoli, kupolí'
    gcVocab = 'kupoli/kupolí/kopuli/kopulí'
;

+ airlockOuterDoor: IndirectDoor
    'venkovní vnější východní vzduchotěsné tlakové dveře/(ven)'
    'venkovní dveře' *3
    "Vypadají jako běžné tlakové dveře, natřené čistě bílou, s kovovými
        výztuhami a maličkým okénkem. Ovládají se pákou na stěně. "

    /* Dveře jsou pomnožné. */
    isPlural = true

    gcName = 'venkovních dveří, venkovním dveřím, venkovní dveře, venkovních
        dveřích, venkovními dveřmi'
    gcVocab = 'venkovních venkovním venkovními vnějších vnějším vnějšími
        východních východním východními vzduchotěsných vzduchotěsným
        vzduchotěsnými tlakových tlakovým tlakovými dveří/dveřím/dveřích/dveřmi'
;

++ ComponentDeferrer, Component
    'vnější maličké okénko vnějších dveří sklo -*okénka*skla'
    'okénko vnějších dveří' *4
    "Je to jen malý průzor velikosti dlaně s tlustým a odolným sklem. "
    
    shouldNotBreakMsg = 'Chvíli jsi nad rozbitím uvažoval, ale když sis
        představil, jak dopadla poslední rvačka v kosmickém baru… Brrr, střepy
        v… raději ani nemyslet. '

    dobjFor(LookThrough)
    {
        verify()
        {
            if(location.isOpen())
                illogicalNow('Dveře jsou zasunuty ve stěně komory, takže okénko
                    je teď schované. ');
        }
        action ()
            { "Vidíš jím kamenitý povrch asteroidu a vesmír okolo. "; }

    }
    dobjFor(LookIn) asDobjFor(LookThrough)
    
    gcName = 'okénka vnějších dveří, okénku vnějších dveří, okénko vnějších
        dveří, okénku vnějších dveří, okénkem vnějších dveří'
    gcVocab = 'maličkého maličkému meličkém maličkým okénka okénku okénkem skla
        sklu sklem -*okének*okénkám*okénkách*okénky*okénkama*okénkami'
;

/* ------------------------------------------------------------------------ */
/*
 *   CollectiveGroup zastupuje individuální objekty, když hráč použije množné
 *   číslo. V tomto případě při prozkoumání pák se místo řady individuálních
 *   repetivních popisků každé páky objeví jeden společný popis.
 */
+ leverGroup: CollectiveGroup, Fixture '*páky*páčky' 'páky' *3
    "Je tu zelená páka ovládající vnitřní dveře a červená páka ovládající
        venkovní dveře. "

    gcName = 'pák, pákám, páky, pákách, pákami'
    gcVocab = '*pák*pákám*pákách*pákami*páček*páčkám*páčkách*páčkami'
;

+ redLever: DoorLever, CustomFixture
    'vnější venkovní červená páka/páčka*páky*páčky' 'červená páka' *3
    "Je označena <q>venkovní dveře</q>. "

    otherLever = greenLever
    myDoor = airlockOuterDoor

    collectiveGroups = [leverGroup]

    gcName = 'červené páky, červené páce, červenou páku, červené páce, červenou
        pákou'
    gcVocab = 'červené červenou páky/páce/páku/páko/pákou/páčky/páčce/páčku/
        páčkou*páky*pák*pákám*pákách*pákami*páček*páčkám*páčkách*páčkami'
;

+ greenLever: DoorLever, CustomFixture
    'vnitřní zelená páka/páčka*páky*páčky' 'zelená páka' *3
    "Je označena <q>vnitřní dveře</q>. "

    isPulled = true
    otherLever = redLever
    myDoor = airlockInnerDoor

    collectiveGroups = [leverGroup]

    gcName = 'zelené páky, zelené páce, zelenou páku, zelené páce, zelenou
        pákou'
    gcVocab = 'zelené zelenou páky/páce/páku/páko/pákou/páčky/páčce/páčku/
        páčkou*páky*pák*pákám*pákách*pákami*páček*páčkám*páčkách*páčkami'
;

/* ------------------------------------------------------------------------ */

+ dialGroup: CollectiveGroup, Fixture '*ciferníky' 'ciferníky' *2
    "Levý ciferník měří tlak vzduchu za vnitřními dveřmi, který je momentálně
        <<dome.pressure>> bar<<dome.pressure == 0 ? 'ů' : ''>>. Prostřední
        ciferník měří tlak vzduchu v přechodové komoře, který je momentálně
        <<airlock.pressure>> bar<<airlock.pressure == 0 ? 'ů' : ''>>. Pravý
        ciferník ukazuje tlak vzduchu za východními (venkovními) dveřmi, který
        je momentálně 0 barů. "

    gcName = 'ciferníků, ciferníkům, ciferníky, cifernících, ciferníky'
    gcVocab = '*ciferníků*ciferníkům*cifernících'
;

+ CustomFixture 'pravý ciferník*ciferníky' 'pravý ciferník' *2
    "Pravý ciferník ukazuje tlak vzduchu za venkovními dveřmi, tj. venku mimo
        základnu. Právě ukazuje 0 barů. "
    
    collectiveGroups = [dialGroup]

    gcName = 'pravého ciferníku, pravému ciferníku, pravý ciferník, pravém
        ciferníku, pravým ciferníkem'
    gcVocab = 'pravého pravému pravém levým ciferníku/ciferníkem*ciferníků*
        ciferníkům*cifernících'
;

+ CustomFixture 'prostřední ciferník*ciferníky' 'prostřední ciferník' *2
    "Prostřední ciferník měří tlak vzduchu v přechodové komoře. Právě ukazuje
    <<airlock.pressure>> bar<<airlock.pressure == 0 ? 'ů' : ''>>. "
    collectiveGroups = [dialGroup]

    gcName = 'prostředního ciferníku, prostřednímu ciferníku, prostřední
        ciferník, prostředním ciferníku, prostředním ciferníkem'
    gcVocab = 'prostředního prostřednímu prostředním ciferníku/ciferníkem*
        ciferníků*ciferníkům*cifernících'
;

+ CustomFixture 'levý ciferník*ciferníky' 'levý ciferník' *2
    "Levý ciferník měří tlak vzduchu za vnitřními dveřmi. Právě ukazuje
        <<dome.pressure>> bar<<dome.pressure == 0 ? 'ů' : ''>>. "
    collectiveGroups = [dialGroup]

    gcName = 'levého ciferníku, levému ciferníku, levý ciferník, levém
        ciferníku, levým ciferníkem'
    gcVocab = 'levého levému levém levým ciferníku/ciferníkem*ciferníků*
        ciferníkům*cifernících'
;
