#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

modify Platform
    hasBeenStoodOn = nil
    dobjFor(StandOn)
    {
        action()
        {
            inherited;
            hasBeenStoodOn = true;
        }
    }
;

/* ------------------------------------------------------------------------ */
/*
 *   SKLAD
 */
supplyRoom: BaseRoom 'Sklad' 'do skladu' 'ze skladu'
    "Sklad je docela rozlehlý, ale většinu prostoru zabírají regály
        s nejrůznějšími balíky obsahující vybavení a náhradní díly. V jednom
        z rohů je vyhrazené místo pro opravy s pracovním stolem a diagnostickým
        přístrojem a poblíž vchodu stojí bíle natřená lékárna.
        <.reveal hint-supply-visited><<if supplyGrating.location>>U stropu se
        táhnou rozvody vzduchotechniky, přímo nad stolem je větrací mřížka. "

    north = corridorWest
    out asExit(north)
    up = srTable.hasBeenStoodOn && supplyGrating.isOpen ? supplyHole : nil

    captainFuse = nil
    captainWalk()
    {
        captain.setCurState(captainGoToCommandersRoom);
        commander.setCurState(commanderGoToCommandersRoom);
    }
    enteringRoom(traveler)
    {
        if(traveler == me && captain.curState == captainChatting
            && captainFuse == nil)
        {
            captainFuse = new Fuse(self, &captainWalk, 3);
        }
    }

    dobjFor(Search) remapTo(LookIn, shelves)
    dobjFor(LookIn) remapTo(LookIn, shelves)

    gender = 4
    changeGender = 'dílna:3'
    vocabWords = 'sklad/skladu/sklad/skladem/dílna/dílny/dílně/dílnu/dílnou'
    gcName = 'skladu, skladu, sklad, skladu, skladem'
;

+ srConducts: PresentLater, OutOfReach, RoomPartItem, Fixture
    'rozvody vzduchotechniky/vzduchotechnika' 'rozvody vzduchotechniky' *2
    "Rozvody se táhnou u okraje místnosti z východu na západ a právě nad stolem
        je větrací mřížka. "

    plKey = 'conducts'
    specialNominalRoomPartLocation = defaultCeiling
    specialDesc = "Pod stropem se táhnou rozvody vzduchotechniky. "
    canObjReachSelf(obj) { return obj.isIn(srTable)
        && obj.posture == standing; }

    dobjFor(Enter) maybeRemapTo(supplyGrating.isOpen, Enter, supplyHole)
    dobjFor(ClimbUp) maybeRemapTo(supplyGrating.isOpen, Enter, supplyHole)

    isPlural = true
    gcName = 'rozvodů vzduchotechniky, rozvodům vzduchotechniky, rozvody
        vzduchotechniky, rozvodech vzduchotechniky, rozvody vzduchotechniky'
    gcVocab = 'rozvodů rozvodům rozvodech rozvody vzduchotechnice/
        vzduchpotechniku/vzduchotechnikou'
;

+ supplyGrating: PresentLater, OutOfReach, Openable, Fixture
    'větrací mřížka' 'větrací mřížka' *3
    "Přímo nad stolem je větrací mřížka rozvodů vzduchotechniky. Brání nasávání
        předmětů do rozvodů. Je poměrně velká, má rozměry cca 60×60 cm. "

    sightSize = small
    tooDistantMsg = 'Mřížka je o kus výše, než kam z podlahy dosáhneš.
        <<gReveal('hint-distant')>> '
    notAContainerMsg = '{Kohoco dobj} nemůžeš do mřížky dát, neprojde úzkými
        otvory. '
    plKey = 'conducts'

    openDesc = isOpen ? 'otevřená, jedna její strana visí na pantech'
        : 'zavřená'

    canObjReachSelf(obj) { return obj.isIn(srTable)
        && obj.posture == standing; }

    dobjFor(Open)
    {
        verify()
        {
            if(!srTable.hasBeenStoodOn) nonObvious;
            else inherited;
        }
        action()
        {
            "Lehce jsi zapáčil po okrajích mřížky a mřížku potichu vyklopil. Pod
                ní se objevil velký větrací otvor. ";

            inherited;
            scoreMarker.awardPointsOnce();
            supplyHole.makeOpen(true);
            supplyNoise.moveInto(supplyHole);
        }
    }
    scoreMarker: Achievement { +3 "objevení vstupu do rozvodů vzduchotechniky" }

    dobjFor(Take) asDobjFor(Open)
    dobjFor(Move) asDobjFor(Open)
    dobjFor(Pull) asDobjFor(Open)
    dobjFor(Unscrew) asDobjFor(Open)
    dobjFor(Detach) asDobjFor(Open)
    dobjFor(Doff) asDobjFor(Open)

    dobjFor(Close)
    {
        verify()
        {
            if(!srTable.hasBeenStoodOn) nonObvious;
            else inherited;
        }
        action()
        {
            "Potichu jsi mřížku zaklapl zpátky na místo. ";

            inherited;
            supplyHole.makeOpen(nil);
            supplyNoise.moveInto(supplyGrating);
        }
    }
    dobjFor(Push) asDobjFor(Close)

    dobjFor(Enter)
    {
        remap = (supplyGrating.isOpen ? [EnterAction, supplyHole] : inherited)
        verify() { illogicalNow('Otvory v mřížce nasazené na rozvodech
            vzduchotechniky jsou příliš úzké.'); }
    }
    dobjFor(ClimbUp) asDobjFor(Enter)

    iobjFor(PutIn)
    {
        remap = (supplyGrating.isOpen ? [PutInAction, DirectObject, supplyHole]
            : inherited)
        verify()
        {
            if(gDobj == picker) illogical('Zkusil jsi, zda jde prostrčit
                podávátko mřížkou a jde to velmi dobře. ');
            else inherited;
        }
    }

    iobjFor(PushTravelThrough)
    {
        verify() {}
    }

    gcName = 'větrací mřížky, větrací mřížce, větrací mřížku, větrací mřížce,
        větrací mřížkou'
    gcVocab = 'mřížky/mřížce/mřížku/mřížkou'
;

++ supplyNoise: Noise 'tiché slabé chrápání/zvuk' 'tiché chrápání' *4

    /* Opakovane pri pobytu v mistnosti podle rozvrhu */
    hereWithSource = "Slyšíš slabý zvuk chrápání. "

    /* prozkoumej chrapani, poslouchej chrapani */
    descWithSource = "Chrápání vychází z <<location.nameKohoCeho>> a je velice
        tiché. "

    /* prozkoumej mrizku (prida na konec), poslouchej mrizku */
    sourceDesc = "Vychází z <<location.zajmenoTebe2N>> slabý zvuk chrápání. "

    displaySchedule = [2, 2, 3, 3, 4]
    noLongerHere()
    {
        if(me.isIn(corridorWest))
            "Chrápání už neslyšíš. ";
    }

    /* Vypneme prenos konektorem na chodbu. */
    soundSize = small
    
    gcName = 'tichého chrápání, tichému chrápání, tiché chrápání,
        tichém chrápání, tichým chrápáním'
    gcVocab = 'tichého tichému tichý tichém tichým slabého slabému slabý slabém
        slabým chrápáním/zvuku/zvukem'
;

+ supplyHole: HiddenDoor
    'větrací otvor' 'větrací otvor' *2
    "Přímo nad stolem je otevřený větrací otvor do rozvodů vzduchotechniky. Je
        poměrně velký, má rozměry cca 60×60 cm. "

    sightSize = small

    connectorStagingLocation = (srTable.hasBeenStoodOn ? srTable : nil)
    canObjReachSelf(obj) { return obj.isIn(srTable) && obj.posture == standing; }
    actorTravelPreCond(actor)
    {
        local loc = connectorStagingLocation;
        if(loc && loc.hasBeenStoodOn)
            return inherited(actor);
        else
            return [];
    }

    dobjFor(ClimbUp) asDobjFor(Enter)
    dobjFor(Open) remapTo(Open, supplyGrating)
    dobjFor(Close) remapTo(Close, supplyGrating)

    iobjFor(PutIn)
    {
        verify() {}
        action()
        {
            "Prostrčil jsi {kohoco dobj} otvorem někam do rozvodů
                vzduchotechniky. ";
            gDobj.moveInto(supplyConducts);
        }
    }

    gcName = 'větracího otvoru, větracímu otvoru, větrací otvor, větracím
        otvoru, větracím otvorem'
    gcVocab = 'větracího větracímu větracím otvoru/otvorem'
;


/* ------------------------------------------------------------------------ */

+ srTable: Platform, Fixture
    'pracovní stůl' 'pracovní stůl' *2
    "Pracovní stůl je vybaven spoustou příchytek, svěrek a zarážek, aby se
        opravované předměty i nářadí v nízké gravitaci nerozlétaly do všech
        stran, světlem, několika nástroji na rozebírání přístrojů a hlavně
        univerzálním diagnostickým přístrojem (UniDiP). "

    maxSingleBulk = 10000
    sightSize = small
    obviousPostures = hasBeenStoodOn ? [sitting, lying, standing] : []

    /*
     *   Jestliže se hráč posadí na stůl a pak použije příkaz "vstaň", tak bude
     *   pochopen jako "stoupni si na stůl" místo "běž pryč ze stolu", takže
     *   pak bude moci otevřít mřížku a jít nahoru, aniž by si uvědomil, že
     *   stoupnutí si na stůl je způsob, jak se k rozvodům vzduchotechniky
     *   dostat. Možným způsobem, jak to vyřešit, je nechat stůl reinterpretovat
     *   příkaz "vstaň" jako "jdi pryč", dokud se na stůl sám vědomě nepostaví.
     */
    roomBeforeAction()
    {
        if(gActionIs(Stand) && !hasBeenStoodOn)
            replaceAction(GetOutOf, self);
    }

    dobjFor(ClimbUp) asDobjFor(StandOn)
    dobjFor(Enter) asDobjFor(StandOn)
    
    gcName = 'pracovního stolu, pracovnímu stolu, pracovní stůl, pracovním
        stole, pracovním stolem'
    gcVocab = 'pracovního pracovnímu pracovním stolu/stole/stolem'
;

++ Decoration
    'dílenské příchytky/svěrky/zarážky/nářadí/nástroje/vybavení'
    'dílenské vybavení' *4
    desc()
    {
        "V nízké gravitaci je potřeba věci přidržovat, aby neodpluly pryč. Proto
            je prakticky každý stůl na kosmické lodi i této základně vybaven
            různými gumovými očky, suchými zipy a jinými pomůckami, které mohou
            zabránit předmětům v pohybu. ";

        if(!picker.discovered)
        {
            "<.p>Mezi hromadou nářadí jsi objevil podávátko na zapadlé
                šroubky. ";
            picker.discover();
            me.setHim(picker);
            scoreMarker.awardPointsOnce();
        }
    }
    scoreMarker: Achievement { +1 "nalezení podávátka" }

    dobjFor(Take) maybeRemapTo(!picker.discovered, Examine, self)

    changeGender = 'přích:5, svěr:5, zar:5, nást:5'
    gcName = 'dílenského vybavení, dílenskému vybavení, dílenské vybavení,
        dílenském vybavení, dílenským vybavením'
    gcVocab = 'dílenského dílenskému dílenském dílenským příchytek/příchytkám/
        příchytkách/příchytkami/svěrek/svěrkám/svěrkách/svěrkami/zarážek/
        zarážkám/zarážkách/zarážkami/nářadím/nástrojů/nástrojům/nástrojích/
        nástroji/vybavení/vybavením'
;

++ picker: Hidden 'podávátko' 'podávátko' *4
    "Nástroj na zachycení vzdálených předmětů. Prakticky to je tenká ohebná
        trubička s chňapkou na konci. Narozdíl od použití na Zemi, tady není
        problém s ohýbáním vlivem gravitace, a tak může být dost dlouhá. Výborný
        nástroj, pokud jím chceš dosáhnout do vzdálených koutů. "

    bulk = 20

    dobjFor(LookIn) asDobjFor(Examine)
    dobjFor(Search) asDobjFor(Examine)

    dobjFor(AttachTo)
    {
        verify()
        {
            if(gIobj != card) inherited();
        }
        action()
        {
            if(gIobj == card) replaceAction(Take, card);
            else inherited();
        }
    }

    dobjFor(PushTravel)
    {
        verify()
        {
            if(gIobj != supplyGrating && gIobj != technicianGrating)
                inherited();
        }
        action()
        {
            if(me.isIn(technicianConducts))
                replaceAction(Take, card);
            else inherited();
        }
    }

    gcName = 'podávátka, podávátku, podávátko, podávátku, podávátkem'
    gcVocab = 'podávátka/podávátku/podávátkem'
;

++ Decoration 'světlo' 'světlo' *4
    "Obyčejná pracovní lampička s nastavitelnou polohou, abys na práci dobře
        viděl. "

    gcName = 'světla, světlu, světlo, světlu, světlem'
    gcVocab = 'světla/světlu/světlem'
;


/* ------------------------------------------------------------------------ */

+ pharmacyCabinet: OpenableContainer, Heavy
    'bílá bíle natřená lékárna/skříňka/přihrádky' 'lékárna' *3
    "Bíle natřená skříňka s červeným křížem. Uvnitř je spousta přihrádek se
        základními léky, obvazy, náplastmi a desinfekcí. Vše je upevněno tak,
        aby se věci po otevření nerozlétaly po okolí. "

    maxSingleBulk = 10000

    changeGender = 'přihr:5'
    gcName = 'lékárny, lékárně, lékárnu, lékárně, lékárnou'
    gcVocab = 'bílé bílou natřené natřenou lékárny/lékárně/lékárnu/lékárnou/
        skříňky/skříňce/skříňku/skříňkou/přihrádek/přihrádkám/přihrádkách/
        přihrádkami'
;

++ CustomFixture 'lékařské vybavení/léky/obvazy/náplasti/desinfekce/šití/jehla'
    'lékařské vybavení' *2
    desc()
    {
        "Náplasti, obvazy, balíčky s desinfikujícími ubrousky, pár zcela
            obyčejných léků na běžné potíže a šití s jehlou pro případ
            zranění. ";

        /* Projímadlo a stetoskop hráč objeví, až je bude potřebovat. */
        local discovery = nil;
        if(gRevealed('coffee') && !syringe.location)
        {
            "<.p>Vida, do oka ti padla plastová injekce. Zdá se, že obsahuje
                projímadlo. ";

            syringe.makePresent();
            discovery = true;
        }
        if(gRevealed('hint-amplify') && !stethoscope.location)
        {
            "<.p>Mezi jiným lékařským vybavením tě zaujal stetoskop, který tu
                leží pro případ potřeby. ";

            stethoscope.makePresent();
            discovery = true;
        }

        if(!discovery)
            "Je toho tu plno, ale nic, co by se dalo teď použít. ";
    }

    cannotTakeMsg = 'Je toho tu plno, ale nemá cenu brát všechno, dokud nevíš
        přesně, co chceš. '

    isListed { return isListedInContents; }
    isListedInContents { return !useSpecialDescInContents(location); }

    isPlural = true
    changeGender = 'jehl:3'
    gcName = 'lékařského vybavení, lékařskému vybavení, lékařské vybavení,
        lékařském vybavení, lékařským vybavením'
    gcVocab = 'lékařského lékařskému lékařském lékařským vybavením/léků/lékům/
        lécích/obvazů/obvazům/obvazech/obvazy/náplastí/náplastím/náplastech/
        náplastmi/desinfekci/desinfekcí/šitím/jehly/jehlu/jehle/jehlou'
;

++ syringe: PresentLater, SimpleAttachable, PlugAttachable, Thing
    'plastová injekce' 'plastová injekce' *3
    "<<if laxative.isIn(self)>>Je to malá plastová injekce bez jehly s plastovým
        pístem. Dávky tekutých léků bývají takto připravené. <<else>>Prázdná
        injekce od dávky silného projímadla. Obsah byl vymačkán do poslední
        kapky. "

    dobjFor(PutIn)
    {
        action()
        {
            if(!gIobj.ofKind(CoffeeBag))
                inherited();
        }
    }
    dobjFor(PourInto) asDobjFor(PutIn)
    dobjFor(Push) remapTo(Push, piston)

    dobjFor(Take)
    {
        action()
        {
            inherited;
            achievement.awardPointsOnce();
        }
    }
    achievement: Achievement { +1 "nalezení projímadla" }

    gcName = 'plastové injekce, plastové injekci, plastovou injekci,
        plastové injekci, plastovou injekcí'
    gcVocab = 'plastové plastovou injekci/injekcí'
;

modify FillMedium
    dobjFor(PutIn) { preCond = [] }
;

+++ laxative: FillMedium 'projímadlo' 'projímadlo' *4
    "<<if isIn(syringe)>>Projímadlo je dávkované v malé injekci, aby se dalo
        snadno přidat do nápoje. Je velice silné a působí rychle.
        <<else>>Projímadlo je rozpuštěné v kávě uvnitř kafovaku. "

    dobjFor(Take) remapTo(Take, location)
    dobjFor(Drop) remapTo(Drop, location)
    
    /*
     *   Dej projimadlo do kafovaku obslouzi kafovak. V ostatnich pripadech
     *   chapeme jako dej kontejner do neceho.
     */
//    dobjFor(PutIn) remapTo(PutIn, location, IndirectObject)
    dobjFor(PourInto) remapTo(PourInto, location, IndirectObject)
    dobjFor(PutOn) remapTo(PutOn, location, IndirectObject)

    /* Pokud by hrac chtel explicitne vyndat projimadlo. */
    dobjFor(TakeFrom)
    {
        verify()
        {
            if(isIn(syringe))
                illogical('Projímadlo je tekuté, takže ho nemůžeš z injekce
                    vyndat. Ale injekci bys mohl k něčemu připojit a projímadlo
                    tam vstříknout. ');
            else
                illogical('Projímadlo je rozpuštěné v kávě, takže ho nemůžeš z
                    kafovaku vyndat. ');
        }
    }
    
    dobjFor(Taste)
    {
        verify() { illogical('Ochutnávat projímadlo, když ho nechceš použít,
            opravdu není dobrý nápad. '); }
    }
    dobjFor(Drink) asDobjFor(Taste)
    dobjFor(Eat) asDobjFor(Taste)

    gcName = 'projímadla, projímadlu, projímadlo, projímadlu, projímadlem'
    gcVocab = 'projímadla/projímadlu/projímadlem'
;

+++ piston: Button, Component 'plastový píst (injekce) -' 'píst' *4
    "Píst injekce slouží k vymáčknutí obsahu. "

    dobjFor(Push)
    {
        check()
        {
            if(location.attachedObjects.length() == 0)
                failCheck('Není dobrý nápad vyprázdnit injekci jen tak do
                    <<getOutermostRoom().pressure == 1 ? 'vzduchu' :
		    'vzuchoprázdna'>>. ');
        }
        action()
        {
            replaceAction(PutIn, laxative, location.attachedObjects[1]);
        }
    }
    dobjFor(Pull)
    {
        verify()
        {
            if(laxative.isIn(syringe))
                illogicalNow('Píst už je vytažen na maximum. ');
        }
    }

    gcName = 'plastového pístu, plastovému pístu, plastový píst,
        plastovém pístu, plastovým pístem'
    gcVocab = 'plastového plastovému plastovém plastovým pístu pístem -'
;

++ stethoscope: PresentLater, Attachable, Wearable 'stetoskop' 'stetoskop' *2
    "Lékařská pomůcka k naslouchání slabých zvuků uvnitř pacienta. Stačí si ho
        nasadit a pak přiložit k tomu, co chceš poslouchat. "

    canAttachTo(obj) { return obj is in(me, tresor); }
    attachmentLister = perInstance(new stethoscopeSimpleAttachmentLister(self))
    moveWhileAttached(movedObj, newCont)
    {
        foreach(local other in attachedObjects)
            tryImplicitAction(DetachFrom, self, other);
    }
    travelWhileAttached(movedObj, traveler, connector)
    {
        foreach(local other in attachedObjects)
            tryImplicitAction(DetachFrom, self, other);
    }

    alreadyAttachedMsg = '{Kdoco dobj} už {je} přiložený {k/ke iobj}
        {komučemu iobj}. '

    dobjFor(Wear)
    {
        check()
        {
            if(spaceSuit.isWornBy(me))
                failCheck('Nemůžeš používat stetoskop, když máš hlavu s ušima
                    schovanou v přilbě skafandru' + (me.getOutermostRoom()
                    .pressure == 0 ? ' a okolo je vzduchoprázdno. ' : '. '));

            inherited;
        }
    }

    dobjFor(PutOn) maybeRemapTo(gIobj == tresor || gIobj == tresorDoor
        || gIobj == tresorKnob, AttachTo, self, tresor)

    dobjFor(Take)
    {
        action()
        {
            inherited;
            achievement.awardPointsOnce();
        }
    }
    achievement: Achievement { +1 "nalezení stetoskopu" }

    gcName = 'stetoskopu, stetoskopu, stetoskop, stetoskopu, stetoskopem'
    gcVocab = 'stetoskopu/stetoskopem'
;

class stethoscopeSimpleAttachmentLister: SimpleAttachmentLister
    showListPrefixWide(cnt, pov, parent, selector)
    {
        local first = parent.attachedObjects[1];
        gMessageParams(first);
        
        "<.p>\^<<parent.name>> <<parent.slovesoJe>> přiložen {k/ke first} ";
    }
;

/* ------------------------------------------------------------------------ */

+ shelves: Consultable, Fixture, RestrictedContainer
    'regál/regály/řady' 'regály' *2
    "Regály zabírají většinu místnosti a jsou v nich zdánlivě nekonečné řady
        hranatých balíků se zásobami. "

    lookInDesc = "Na prohlížení každého jednotlivého balíku nemáš čas, to bys
        tu byl do vánoc. Ale balíky jsou v regálech dobře roztříděné, takže
        najít konkrétní balík určitě nebude problém, jakmile budeš vědět, který
        hledáš. "

    topicNotFound() { "Pochopit zdejší organizační systém ukládání zásob není
        složité, ale tohle tu prostě nikde nedokážeš najít. "; }

    validContents = [c3a24Package]

    descContentsLister: ContentsLister, BaseThingContentsLister
    {
        showListPrefixWide(itemCount, pov, parent, selector)
        {
            gMessageParams(parent);
            "V {komčem parent} je kromě mnoha jiných balíků zasunutý i ";
        }

        showListSuffixWide(itemCount, pov, parent, selector) { ". "; }

        showListItem(obj, options, pov, infoTab)
        {
            obj.showListItem(options | ListKdoCo, pov, infoTab);
        }
    }
    contentsLister = descContentsLister

    /* Balík musí jít do regálu vrátit. */
    iobjFor(PutOn) asIobjFor(PutIn)
    iobjFor(PutIn)
    {
        action()
        {
            "Vrátil jsi {kohoco dobj} zpátky, kam patří. ";
            inherited();
        }
    }
    
    dobjFor(LookIn)
    {
        verify() { logicalRank(50, 'decoration'); }
        action()
        {
            if(gRevealed('low-stock'))
                replaceAction(ConsultAbout, self, c3a24Package);
            else
                inherited();
        }
    }

    isPlural = true
    gcName = 'regálů, regálům, regály, regálech, regály'
    gcVocab = 'regálů/regálům/regálech/regálu/regálem/řad/řadám/řadách/řadami/
        řadě/řadu/řadou'
;

++ packages: Consultable, Fixture
    'hranaté balíky/bedny' 'balíky' *2

    cannotPutMsg = 'Na to, abys je vzal všechny, jich je tu trochu moc. '

    dobjFor(Search) remapTo(LookIn, location)
    dobjFor(Examine) remapTo(LookIn, location)
    dobjFor(LookIn) remapTo(LookIn, location)
    dobjFor(Take) remapTo(LookIn, location)
    dobjFor(Read) remapTo(LookIn, location)

    dobjFor(Move)
    {
        verify() { }
        action() { "Trochu jsi urovnal několik balíků na kraji regálu, aby byly
            hezky vyrovnané. "; }
    }
    dobjFor(Turn) asDobjFor(Move)
    dobjFor(Pull) asDobjFor(Move)
    dobjFor(Push) asDobjFor(Move)

    dobjFor(Consult) remapTo(Consult, location)
    dobjFor(ConsultAbout) remapTo(ConsultAbout, location, IndirectObject)

    changeGender = 'bedn:3'
    isPlural = true
    gcName = 'balíků, balíkům, balíky, balících, balíky'
    gcVocab = 'hranatých hranatým hranatými balíků/balíkům/balících/beden/
        bednám/bednách/bednami'
;

++ c3a24Topic: ConsultTopic
    [brokenComponents, fixedComponents, c3a24Package, c3a24Unpackage]

    topicResponse()
    {
        if(c3a24Package.location == nil)
        {
            c3a24Package.makePresent();

            "Prohlédl jsi vyrovnané řady balíků podle označení a vida, je mezi
                nimi i ten C3-A24. ";

            gActor.setHim(c3a24Package);
        }
        else if(c3a24Package.location == shelves)
            "Prohlédl jsi vyrovnané řady balíků podle označení a vida, je mezi
                nimi i ten C3-A24. ";
        else
            "Našel jsi prázdné místo, kam balík patří, ale teď zrovna v regálu
                není. ";
    }
;

++ c3a24Unpackage: Unthing
    'balík bedna C3-A24' 'balík C3-A24' *2

    desc() { say(notHereMsg); }

    notHereMsg = 'Na první pohled ten balík nevidíš nikde se povalovat, ale
        balíků je tu sposta, takže bys ho mohl zkusit najít, když regály
        prohledáš. '
;

++ c3a24Package: PresentLater, ComplexContainer
    'balík bedna C3-A24' 'balík C3-A24' *2
    "Je to hranatý vak z tuhého bílého plátna uzavřený na zip. Nijak se neliší
        od ostatních balíků se zásobami materiálu. "

    isListedInContents = !newComponent.moved

    dobjFor(LookIn) asDobjFor(Examine)
    dobjFor(Search) asDobjFor(Examine)

    cannotConsultMsg = 'Úplně postačí, když balík otevřeš. '

    subContainer: ComplexComponent, Openable, RestrictedContainer
    {
        validContents = [newComponent]
        dobjFor(Open)
        {
            action()
            {
                inherited();
                gReveal('viz54-found');
                if(!newComponent.moved)
                    nestedAction(Examine, newComponent);
            }
        }
    }

    gcName = 'balíku C3-A24, balíku C3-A24, balík C3-A24, balíku C3-A24,
        balíkem C3-A24'
    gcVocab = 'balíku balíkem bedny bedně bednu bednou -'
;

+++ ContainerDoor 'zip' 'zip' *2
    "Zip je moderní konstrukce z odolných plastů. Když je zazipovaný, drží jak
        přibitý. "

    gcName = 'zipu, zipu, zip, zipu, zipem'
    gcVocab = 'zipu/zipem'
;

+++ newComponent: Thing
    'nová nový náhradní zesilovač součástka/součástky/díl/VIZ-54/VIZ54/VIZ/
        pouzdro*součástky' 'nová součástka' *3
    "Je to výkonový integrovaný zesilovač VIZ-54 v keramicko-kovovém pouzdře s
        otvorem na přišroubování k chladiči. Vypadá nově a hezky se leskne.
        Bohužel je jen jeden a potřebuješ tři. "

    subLocation = &subContainer

    collectiveGroups = [componentsGroup]
    listWith = [componentsListGroup]

    gcName = 'nové součástky, nové součástce, novou součástku, nové součástce,
        novou součástkou'
    gcVocab = 'nové novou nového novému novém novým náhradním součástky/
        součástce/součástku/součástkou/zesilovače/zesilovači/zesilovačem/dílu/
        dílem/pouzdra/pouzdru/pouzdrem*součástek*součástkám*součástkách*
        součástkami'
;

componentsGroup: CollectiveGroup
    '*součástky*součástek*součástkám*součástkách*součástkami' 'součástky' *3
    "Jsou to výkonové integrované zesilovače VIZ-54 v keramicko--kovovém pouzdře
        s otvorem na přišroubování k chladiči. Tři z nich mají podezřele
        ožehnuté pouzdro a jeden je překrásně lesklý a vypadá nepoužitě. "

    isCollectiveAction(action, whichObj)
    {
        if (action.baseActionClass is in (ExamineAction, ReadAction,
            GiveToAction, ShowToAction) && newComponent.isDirectlyIn(me)
            && brokenComponents.isDirectlyIn(me)) return true;

         return nil;
     }
     dobjFor(Read) asDobjFor(Examine)
;

componentsListGroup: ListGroupParen
    showGroupCountName(lst)
    {
        "zesilovače VIZ-54";
    }
;
